/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.soql.parser;

import java.util.List;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.CommonTree;
import org.mule.tools.soql.parser.SOQLCommonTree;
import org.mule.tools.soql.parser.utils.SOQLCommonTreeUtils;
import org.mule.tools.soql.query.from.ObjectSpec;

public class ObjectSpecNode
extends SOQLCommonTree {
    public ObjectSpecNode(int tokenType) {
        super((Token)new CommonToken(tokenType, "OBJECT_SPEC"));
    }

    public ObjectSpec createSOQLData() {
        ObjectSpec objectSpec = new ObjectSpec();
        this.processFirstNode(objectSpec);
        this.processSecondNode(objectSpec);
        this.processThirdNode(objectSpec);
        return objectSpec;
    }

    private void processFirstNode(ObjectSpec objectSpec) {
        CommonTree child = (CommonTree)this.getChild(0);
        if (child == null) {
            return;
        }
        if (SOQLCommonTreeUtils.matchesAnyType(child, 131).booleanValue()) {
            this.fillObjectPrefixNames(child, objectSpec);
        } else {
            objectSpec.setObjectName(child.getText());
        }
    }

    private void processSecondNode(ObjectSpec objectSpec) {
        CommonTree child = (CommonTree)this.getChild(1);
        if (child == null) {
            return;
        }
        if (objectSpec.getObjectName() == null) {
            objectSpec.setObjectName(child.getText());
        } else {
            objectSpec.setAlias(child.getText());
        }
    }

    private void processThirdNode(ObjectSpec objectSpec) {
        CommonTree child = (CommonTree)this.getChild(2);
        if (child == null) {
            return;
        }
        objectSpec.setAlias(child.getText());
    }

    private void fillObjectPrefixNames(CommonTree node, ObjectSpec objectSpec) {
        List children = node.getChildren();
        if (children == null) {
            return;
        }
        for (CommonTree child : children) {
            objectSpec.addObjectPrefixName(child.getText());
        }
    }
}

