/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.artifact.archiver.internal;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.mule.tools.artifact.archiver.internal.FileComparator;

public class FileCollection {
    private Set<File> files = new TreeSet<File>(new FileComparator());
    private Set<File> folders = new TreeSet<File>(new FileComparator());
    private Set<File> exclusions = new TreeSet<File>(new FileComparator());
    private boolean returnDirectoriesOnly;

    public void addFile(File file) {
        this.files.add(file);
    }

    public void addFiles(File ... files) {
        for (File file : files) {
            this.files.add(file);
        }
    }

    public void addFolder(File folder) {
        this.folders.add(folder);
    }

    public void addFolders(File ... folders) {
        for (File folder : folders) {
            this.folders.add(folder);
        }
    }

    public Collection<File> allFiles() {
        TreeSet<File> files = new TreeSet<File>(new FileComparator());
        if (this.returnDirectoriesOnly) {
            for (File folder : this.folders) {
                if (!folder.exists() || this.exclusions.contains(folder)) continue;
                files.add(folder);
            }
        } else {
            this.addFilesWithoutExclusions(this.files, files);
            for (File folder : this.folders) {
                if (!folder.exists()) continue;
                List<File> folderFiles = Arrays.asList(folder.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.isFile() && !file.isHidden() && file.exists();
                    }
                }));
                this.addFilesWithoutExclusions(folderFiles, files);
            }
        }
        return files;
    }

    private void addFilesWithoutExclusions(Collection<File> filesToAdd, Set<File> files) {
        for (File file : filesToAdd) {
            if (this.exclusions.contains(file)) continue;
            files.add(file);
        }
    }

    public FileCollection returnDirectoriesOnly() {
        this.returnDirectoriesOnly = true;
        return this;
    }

    public void excludeFiles(File ... files) {
        this.exclusions.addAll(Arrays.asList(files));
    }

    public Set<File> allExcludedFiles() {
        return this.exclusions;
    }
}

