/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.artifact.archiver.api;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.tools.artifact.archiver.internal.MuleArchiver;
import org.mule.tools.artifact.archiver.internal.packaging.PackageStructureValidator;
import org.mule.tools.artifact.archiver.internal.packaging.PackagingTypeFactory;
import org.mule.tools.artifact.archiver.internal.packaging.type.PackagingType;

public class PackageBuilder {
    public static final String POM = "pom.xml";
    public static final String MULE_APP_PROPERTIES = "mule-app.properties";
    public static final String MULE_DEPLOY_PROPERTIES = "mule-deploy.properties";
    public static final String CLASSES_FOLDER = "classes";
    public static final String LIB_FOLDER = "lib";
    public static final String MULE_FOLDER = "mule";
    public static final String METAINF_FOLDER = "META-INF";
    public static final String PLUGINS_FOLDER = "plugins";
    private static PackagingType packagingType;
    private File classesFolder = null;
    private File libFolder = null;
    private File muleFolder = null;
    private File metaInfFolder = null;
    private File pluginsFolder = null;
    private List<File> rootResources = new ArrayList<File>();
    private File pomFile = null;
    private File muleDeployPropertiesFile = null;
    private File muleAppPropertiesFile = null;
    private File destinationFile;
    private MuleArchiver archiver = null;
    private transient Log log = LogFactory.getLog(this.getClass());
    private PackageStructureValidator applicationStructureValidator;

    public PackageBuilder(PackagingType packagingType) {
        PackageBuilder.packagingType = packagingType;
    }

    public PackageBuilder() {
        this(PackagingTypeFactory.getDefaultPackaging());
    }

    public PackageBuilder withArchiver(MuleArchiver archiver) {
        Preconditions.checkNotNull((Object)((Object)archiver), (Object)"The archiver must not be null");
        this.archiver = archiver;
        return this;
    }

    public PackageBuilder withPom(File file) {
        Preconditions.checkArgument((boolean)file.getName().equals(POM), (Object)"File must be named pom.xml");
        this.pomFile = file;
        return this;
    }

    public PackageBuilder withMuleDeployProperties(File file) {
        Preconditions.checkArgument((boolean)file.getName().equals(MULE_DEPLOY_PROPERTIES), (Object)"File must be named mule-deploy.properties");
        this.muleDeployPropertiesFile = file;
        return this;
    }

    public PackageBuilder withMuleAppProperties(File file) {
        Preconditions.checkArgument((boolean)file.getName().equals(MULE_APP_PROPERTIES), (Object)"File must be named mule-app.properties");
        this.muleAppPropertiesFile = file;
        return this;
    }

    public PackageBuilder withClasses(File folder) {
        Preconditions.checkNotNull((Object)folder, (Object)"The folder must not be null");
        this.classesFolder = folder;
        return this;
    }

    public PackageBuilder withLib(File folder) {
        Preconditions.checkNotNull((Object)folder, (Object)"The folder must not be null");
        this.libFolder = folder;
        return this;
    }

    public PackageBuilder withMule(File folder) {
        Preconditions.checkNotNull((Object)folder);
        this.muleFolder = folder;
        return this;
    }

    public PackageBuilder withMetaInf(File folder) {
        Preconditions.checkNotNull((Object)folder, (Object)"The folder must not be null");
        this.metaInfFolder = folder;
        return this;
    }

    public PackageBuilder withPlugins(File folder) {
        Preconditions.checkNotNull((Object)folder, (Object)"The folder must not be null");
        this.pluginsFolder = folder;
        return this;
    }

    public PackageBuilder withRootResource(File resource) {
        Preconditions.checkNotNull((Object)resource, (Object)"The resource must not be null");
        this.rootResources.add(resource);
        return this;
    }

    public PackageBuilder withDestinationFile(File file) {
        Preconditions.checkNotNull((Object)file, (Object)"The file must not be null");
        Preconditions.checkArgument((!file.exists() ? 1 : 0) != 0, (Object)"The file must not be duplicated");
        this.destinationFile = file;
        return this;
    }

    public void createDeployableFile() throws IOException {
        this.runPrePackageValidations();
        MuleArchiver archiver = this.getMuleArchiver();
        if (null != this.muleFolder && this.muleFolder.exists() && this.muleFolder.isDirectory()) {
            archiver.addMule(this.muleFolder, null, null);
        }
        if (null != this.classesFolder && this.classesFolder.exists() && this.classesFolder.isDirectory()) {
            archiver.addClasses(this.classesFolder, null, null);
        }
        if (null != this.libFolder && this.libFolder.exists() && this.libFolder.isDirectory()) {
            archiver.addLib(this.libFolder, null, null);
        }
        if (null != this.metaInfFolder && this.metaInfFolder.exists() && this.metaInfFolder.isDirectory()) {
            archiver.addMetaInf(this.metaInfFolder, null, null);
        }
        if (null != this.pluginsFolder && this.pluginsFolder.exists() && this.pluginsFolder.isDirectory()) {
            archiver.addPlugins(this.pluginsFolder, null, null);
        }
        if (null != this.muleAppPropertiesFile && this.muleAppPropertiesFile.exists() && this.muleAppPropertiesFile.isFile()) {
            archiver.addRootFile(this.muleAppPropertiesFile);
        }
        if (null != this.muleDeployPropertiesFile && this.muleDeployPropertiesFile.exists() && this.muleDeployPropertiesFile.isFile()) {
            archiver.addRootFile(this.muleDeployPropertiesFile);
        }
        if (null != this.pomFile && this.pomFile.exists() && this.pomFile.isFile()) {
            archiver.addRootFile(this.pomFile);
        }
        archiver.setDestFile(this.destinationFile);
        archiver.createArchive();
    }

    public void setApplicationStructureValidator(PackageStructureValidator applicationStructureValidator) {
        this.applicationStructureValidator = applicationStructureValidator;
    }

    private void runPrePackageValidations() {
        Preconditions.checkNotNull((Object)this.destinationFile, (Object)"The destination file has not been set");
    }

    private void checkMandatoryFolder(File folder) {
        Preconditions.checkNotNull((Object)folder, (Object)"The folder must not be null");
        Preconditions.checkArgument((boolean)folder.exists(), (Object)"The folder must exists");
        Preconditions.checkArgument((boolean)folder.isDirectory(), (Object)"The folder must be a valid directory");
    }

    public PackageBuilder addRootResourcesFile(File file) {
        return this;
    }

    public MuleArchiver getMuleArchiver() {
        if (this.archiver == null) {
            this.archiver = new MuleArchiver();
        }
        return this.archiver;
    }

    public void generateArtifact(File targetFolder, File destinationFile) throws IOException {
        this.checkMandatoryFolder(targetFolder);
        Preconditions.checkNotNull((Object)destinationFile);
        Preconditions.checkArgument((destinationFile != null && !destinationFile.exists() ? 1 : 0) != 0, (Object)"Destination file must not be null or already exist");
        File[] files = targetFolder.listFiles();
        if (files == null) {
            this.log.warn((Object)"The provided target folder is empty, no file will be generated");
            return;
        }
        if (this.getApplicationPackageStructureValidator().hasExpectedStructure(files)) {
            Map<String, File> fileMap = Arrays.stream(files).collect(Collectors.toMap(File::getName, Function.identity()));
            packagingType.applyPackaging(this, fileMap).withDestinationFile(destinationFile);
            this.createDeployableFile();
            this.log.info((Object)("File " + destinationFile.getName() + " has been successfully created"));
        } else {
            this.log.warn((Object)"The provided target folder does not have the expected structure");
        }
    }

    public PackageStructureValidator getApplicationPackageStructureValidator() {
        return this.applicationStructureValidator != null ? this.applicationStructureValidator : new PackageStructureValidator(packagingType);
    }
}

