/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.artifact.archiver.internal;

import java.io.File;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.util.DirectoryScanner;

public class MuleArchiver
extends ZipArchiver {
    public static final String LIB_LOCATION = "lib" + File.separator;
    public static final String CLASSES_LOCATION = "classes" + File.separator;
    public static final String ROOT_LOCATION = "";

    public void addResourcesFile(File file) throws ArchiverException {
        this.addResourcesFileToPath(file, ROOT_LOCATION);
    }

    public void addResourcesFileToPath(File file, String path) throws ArchiverException {
        this.addFile(file, path + file.getName());
    }

    public void addResources(File directoryName) throws ArchiverException {
        this.addResourcesToPath(directoryName, ROOT_LOCATION);
    }

    public void addResourcesToPath(File directoryName, String path) throws ArchiverException {
        this.addDirectory(directoryName, path, null, this.addDefaultExcludes(null));
    }

    public void addLib(File file) throws ArchiverException {
        this.addFile(file, LIB_LOCATION + file.getName());
    }

    public void addClasses(File directoryName, String[] includes, String[] excludes) throws ArchiverException {
        this.addDirectory(directoryName, CLASSES_LOCATION, includes, this.addDefaultExcludes(excludes));
    }

    private String[] addDefaultExcludes(String[] excludes) {
        if (excludes == null || excludes.length == 0) {
            return DirectoryScanner.DEFAULTEXCLUDES;
        }
        String[] newExcludes = new String[excludes.length + DirectoryScanner.DEFAULTEXCLUDES.length];
        System.arraycopy(DirectoryScanner.DEFAULTEXCLUDES, 0, newExcludes, 0, DirectoryScanner.DEFAULTEXCLUDES.length);
        System.arraycopy(excludes, 0, newExcludes, DirectoryScanner.DEFAULTEXCLUDES.length, excludes.length);
        return newExcludes;
    }
}

