/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.artifact.archiver.api;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.mule.tools.artifact.archiver.internal.FileCollection;
import org.mule.tools.artifact.archiver.internal.MuleArchiver;

public class MuleApplicationArchiveBuilder {
    private static final String MULE_DEPLOY_PROPERTIES = "mule-deploy.properties";
    private static final String MULE_APP_PROPERTIES = "mule-app.properties";
    private static final String MULE_CONFIG_XML = "mule-config.xml";
    private final FileCollection jarFolders = new FileCollection();
    private final FileCollection rootResourceFolder = new FileCollection();
    private final FileCollection resourceFolders = new FileCollection().returnDirectoriesOnly();
    private final FileCollection classesFolders = new FileCollection().returnDirectoriesOnly();
    private final Map<String, FileCollection> extraResources = new HashMap<String, FileCollection>();
    private File destinationFile;

    public MuleApplicationArchiveBuilder setMuleDeployPropertiesFile(File muleDeployPropertiesFile) {
        if (!muleDeployPropertiesFile.getName().equals(MULE_DEPLOY_PROPERTIES)) {
            throw new IllegalArgumentException("File must be named mule-deploy.properties");
        }
        this.rootResourceFolder.addFile(muleDeployPropertiesFile);
        return this;
    }

    public MuleApplicationArchiveBuilder setMuleAppPropertiesFile(File muleAppPropertiesFile) {
        if (!muleAppPropertiesFile.getName().equals(MULE_APP_PROPERTIES)) {
            throw new IllegalArgumentException("File must be named mule-app.properties");
        }
        this.rootResourceFolder.addFile(muleAppPropertiesFile);
        return this;
    }

    public MuleApplicationArchiveBuilder setMuleConfigFile(File muleConfigFile) {
        if (!muleConfigFile.getName().equals(MULE_CONFIG_XML)) {
            throw new IllegalArgumentException("File must be named mule-config.xml");
        }
        this.rootResourceFolder.addFile(muleConfigFile);
        return this;
    }

    public MuleApplicationArchiveBuilder setAppResourceFolder(File appResourceFolder) {
        this.rootResourceFolder.addFolder(appResourceFolder);
        return this;
    }

    public MuleApplicationArchiveBuilder setDestinationFile(File destinationFile) {
        this.destinationFile = destinationFile;
        return this;
    }

    public MuleApplicationArchiveBuilder addRootResourcesFolder(File folder) {
        this.rootResourceFolder.addFolder(folder);
        return this;
    }

    public MuleApplicationArchiveBuilder addExtraResourceFolder(File folder, String path) {
        FileCollection pathCollection = this.extraResources.containsKey(path = this.sanitizePath(path)) ? this.extraResources.get(path) : new FileCollection();
        pathCollection.addFolder(folder);
        this.extraResources.put(path, pathCollection);
        return this;
    }

    public MuleApplicationArchiveBuilder addExtraResourceFile(File file, String path) {
        FileCollection pathCollection = this.extraResources.containsKey(path = this.sanitizePath(path)) ? this.extraResources.get(path) : new FileCollection();
        pathCollection.addFile(file);
        this.extraResources.put(path, pathCollection);
        return this;
    }

    private String sanitizePath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path can not be null");
        }
        if (path.isEmpty()) {
            return path;
        }
        if (!path.endsWith("/")) {
            return path + "/";
        }
        return path;
    }

    public MuleApplicationArchiveBuilder addRootResourcesFile(File file) {
        this.rootResourceFolder.addFile(file);
        return this;
    }

    public MuleApplicationArchiveBuilder addResourcesFolder(File folder) {
        this.resourceFolders.addFolder(folder);
        return this;
    }

    public MuleApplicationArchiveBuilder addResourcesFolders(File ... folders) {
        this.resourceFolders.addFolders(folders);
        return this;
    }

    public MuleApplicationArchiveBuilder addClassesFolder(File folder) {
        this.classesFolders.addFolder(folder);
        return this;
    }

    public MuleApplicationArchiveBuilder addClassesFolders(File ... folders) {
        this.classesFolders.addFolders(folders);
        return this;
    }

    public MuleApplicationArchiveBuilder excludeFromClassesFolder(File ... files) {
        this.resourceFolders.excludeFiles(files);
        return this;
    }

    public MuleApplicationArchiveBuilder addJarLibrary(File jarFile) {
        this.jarFolders.addFile(jarFile);
        return this;
    }

    public MuleApplicationArchiveBuilder addJarLibraries(File ... jarFiles) {
        this.jarFolders.addFiles(jarFiles);
        return this;
    }

    public MuleApplicationArchiveBuilder addJarLibraryFolder(File folder) {
        this.jarFolders.addFolder(folder);
        return this;
    }

    public void createDeployableFile() throws IOException {
        MuleArchiver muleArchiver = new MuleArchiver();
        for (File file : this.jarFolders.allFiles()) {
            muleArchiver.addLib(file);
        }
        for (File file : this.classesFolders.allFiles()) {
            muleArchiver.addClasses(file, null, this.transformToPatterns(this.resourceFolders.allExcludedFiles()));
        }
        for (File file : this.resourceFolders.allFiles()) {
            muleArchiver.addClasses(file, null, this.transformToPatterns(this.resourceFolders.allExcludedFiles()));
        }
        for (File file : this.rootResourceFolder.allFiles()) {
            if (file.isFile()) {
                muleArchiver.addResourcesFile(file);
                continue;
            }
            muleArchiver.addResources(file);
        }
        for (Map.Entry entry : this.extraResources.entrySet()) {
            for (File resourceFile : ((FileCollection)entry.getValue()).allFiles()) {
                if (resourceFile.isFile()) {
                    muleArchiver.addResourcesFileToPath(resourceFile, (String)entry.getKey());
                    continue;
                }
                muleArchiver.addResourcesToPath(resourceFile, (String)entry.getKey());
            }
        }
        muleArchiver.setDestFile(this.destinationFile);
        muleArchiver.createArchive();
    }

    private String[] transformToPatterns(Set<File> files) {
        String[] patterns = new String[files.size()];
        int i = 0;
        for (File file : files) {
            patterns[i] = "**/" + file.getName();
            ++i;
        }
        return patterns;
    }
}

