/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.siebel.businessservice;

import com.siebel.data.SiebelException;
import com.siebel.data.SiebelPropertySet;
import com.siebel.data.SiebelService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.mule.modules.siebel.api.SiebelDataBeanClient;
import org.mule.modules.siebel.businessservice.Config;
import org.mule.modules.siebel.util.BusCompQuery;
import org.mule.modules.siebel.util.SiebelConnectorUtils;

public class SiebelBusServiceConnector {
    private Map<String, List<Map<String, Object>>> serviceMethodArgsCache = new HashMap<String, List<Map<String, Object>>>();
    private Config config;

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public Map<String, Object> execute(String serviceName, String methodName, Map<String, Object> input) throws SiebelException {
        SiebelService service = this.getConfig().getClient().getService(serviceName);
        Map inputMap = SiebelConnectorUtils.mergePropertyMaps(this.createBusServiceInputMap(serviceName), input);
        SiebelPropertySet output = new SiebelPropertySet();
        if (!service.invokeMethod(methodName, SiebelConnectorUtils.mapToPropertySet((Map)inputMap), output)) {
            return null;
        }
        service.release();
        return SiebelConnectorUtils.mergePropertyMaps((Map)inputMap, (Map)SiebelConnectorUtils.propertySetToMap((SiebelPropertySet)output));
    }

    public Map<String, Object> executeBusinessService(String businessService, Map<String, Object> inputProperties) throws SiebelException {
        SiebelService service = this.getConfig().getClient().getService(SiebelConnectorUtils.extractBusinessServiceName((String)businessService));
        Map inputMap = SiebelConnectorUtils.mergePropertyMaps(this.createBusServiceInputMap(businessService), inputProperties);
        SiebelPropertySet output = new SiebelPropertySet();
        if (!service.invokeMethod(SiebelConnectorUtils.extractBusinessServiceMethodName((String)businessService), SiebelConnectorUtils.mapToPropertySet((Map)inputMap), output)) {
            return null;
        }
        service.release();
        return SiebelConnectorUtils.mergePropertyMaps((Map)inputMap, (Map)SiebelConnectorUtils.propertySetToMap((SiebelPropertySet)output));
    }

    private Map<String, Object> createBusServiceInputMap(String businessService) throws SiebelException {
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        List<Map<String, Object>> serviceMethodArgs = this.getBusinessServiceMethodArgs(businessService);
        for (Map<String, Object> methodArg : serviceMethodArgs) {
            if (methodArg.get("Data Type").equals("Integration Object") && StringUtils.isNotEmpty((String)((String)methodArg.get("Integration Object")))) {
                objectMap.put((String)methodArg.get("Name"), SiebelConnectorUtils.propertySetToMap((SiebelPropertySet)SiebelConnectorUtils.createEmptyPropertySetFromIntegrationObject((SiebelDataBeanClient)this.getConfig().getClient(), (String)((String)methodArg.get("Integration Object"))).getChild(0)));
                continue;
            }
            objectMap.put((String)methodArg.get("Name"), null);
        }
        return objectMap;
    }

    private List<Map<String, Object>> getBusinessServiceMethodArgs(String businessServiceFullName) throws SiebelException {
        List serviceMethodArgs = this.serviceMethodArgsCache.get(businessServiceFullName);
        if (serviceMethodArgs != null) {
            return serviceMethodArgs;
        }
        ArrayList<String> fieldsToRetrieve = new ArrayList<String>();
        fieldsToRetrieve.add("Id");
        HashMap<String, String> searchSpec = new HashMap<String, String>();
        searchSpec.put("Parent Name", SiebelConnectorUtils.extractBusinessServiceName((String)businessServiceFullName));
        searchSpec.put("Name", SiebelConnectorUtils.extractBusinessServiceMethodName((String)businessServiceFullName));
        BusCompQuery query = new BusCompQuery(this.getConfig().getClient(), "Repository Details.Repository Business Service Method");
        query.setFieldsToRetrieve(fieldsToRetrieve).setSearchSpecification(searchSpec).setViewMode(Integer.valueOf(this.getConfig().getDefaultViewMode()));
        String businessServiceMethodId = (String)((Map)query.executeQuery().get(0)).get("Id");
        fieldsToRetrieve.clear();
        fieldsToRetrieve.add("Parent Id");
        fieldsToRetrieve.add("Name");
        fieldsToRetrieve.add("Type");
        fieldsToRetrieve.add("Integration Object");
        fieldsToRetrieve.add("Data Type");
        String searchQuery = String.format("([Parent Id] = '%s' AND [Inactive] = 'N')", businessServiceMethodId);
        query = new BusCompQuery(this.getConfig().getClient(), "Repository Details.Repository Business Service Method Arg");
        query.setFieldsToRetrieve(fieldsToRetrieve).setSearchExpression(searchQuery).setViewMode(Integer.valueOf(this.getConfig().getDefaultViewMode()));
        serviceMethodArgs = query.executeQuery();
        this.serviceMethodArgsCache.put(businessServiceFullName, serviceMethodArgs);
        return serviceMethodArgs;
    }
}

