package org.mule.devkit.wsdl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PortType implements Identifiable{
	private String name;
	
	private List<Operation> operations;
	private Map<String,Operation> operationsMap;
	
	public Map<String, Operation> getOperationsMap() {
		return operationsMap;
	}
	public List<Operation> getOperations() {
		if(operations==null)
			operations = new ArrayList<Operation>();
		return operations;
	}
	public void setOperations(List<Operation> operations) {
		this.operations = operations;
	}
	public void addOperation(Operation operation) {
		this.getOperations().add(operation);
	}
	
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	public String getId() {
		return getName();
	}
}
