package org.mule.devkit.wsdl;

import java.util.ArrayList;
import java.util.List;

public class Operation implements Identifiable {
	private String documentation;
	private String name;
	private Input input;
	private Output output;
	private List<Fault> faults;
	private String parameterOrder;
	public String getDocumentation() {
		return documentation;
	}

	public void setDocumentation(String documentation) {
		this.documentation = documentation;
	}

	public Input getInput() {
		return input;
	}

	public void setInput(Input input) {
		this.input = input;
	}

	public Output getOutput() {
		return output;
	}

	public void setOutput(Output output) {
		this.output = output;
	}

	public List<Fault> getFaults() {
		if(faults==null)
			faults = new ArrayList<Fault>();
		return faults;
	}

	public void setFaults(List<Fault> faults) {
		this.faults = faults;
	}

	public void addFault(Fault fault) {
		this.getFaults().add(fault);
	}
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getParameterOrder() {
		return parameterOrder;
	}

	public void setParameterOrder(String parameterOrder) {
		this.parameterOrder = parameterOrder;
	}

	public String getId() {
		return getName();
	}
}
