/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.wsdl.parser;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Stack;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.io.FileUtils;
import org.mule.devkit.wsdl.Address;
import org.mule.devkit.wsdl.Binding;
import org.mule.devkit.wsdl.Definition;
import org.mule.devkit.wsdl.Fault;
import org.mule.devkit.wsdl.Header;
import org.mule.devkit.wsdl.Input;
import org.mule.devkit.wsdl.Message;
import org.mule.devkit.wsdl.ObjectType;
import org.mule.devkit.wsdl.Operation;
import org.mule.devkit.wsdl.Output;
import org.mule.devkit.wsdl.Part;
import org.mule.devkit.wsdl.Port;
import org.mule.devkit.wsdl.PortType;
import org.mule.devkit.wsdl.Schema;
import org.mule.devkit.wsdl.Service;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WSDLReader {
    private static final Logger logger = Logger.getLogger(WSDLReader.class.getName());
    private Element root;
    private Definition def;
    private static final String SERVICE = "service";
    private static final String PORT = "port";
    private static final String ADDRESS = "address";
    private static final String BINDING = "binding";
    private static final String OPERATION = "operation";
    private static final String INPUT = "input";
    private static final String HEADER = "header";
    private static final String OUTPUT = "output";
    private static final String FAULT = "fault";
    private static final String PORT_TYPE = "portType";
    private static final String DOCUMENTATION = "documentation";
    private static final String SCHEMA = "schema";
    private static final String IMPORT = "import";
    private static final String INCLUDE = "include";
    private static final String TYPES = "types";
    private static final String COMPLEX_TYPE = "complexType";
    private static final String SIMPLE_TYPE = "simpleType";
    private static final String ELEMENT = "element";
    private static final String MESSAGE = "message";
    private static final String PART = "part";
    private static final String SEQUENCE = "sequence";
    private static final String COMPLEX_CONTENT = "complexContent";
    private static final String EXTENSION = "extension";
    private static final String RESTRICTION = "restriction";
    private Stack<String> paths = new Stack();
    private File tempDir;

    public Definition getFromWsdl(String path) throws ParserConfigurationException, SAXException, IOException, DOMException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        this.loadWsdlDoc(path);
        this.def = new Definition();
        this.def.setFileName(path);
        this.populteDefinition();
        return this.def;
    }

    private void populteDefinition() throws DOMException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        logger.info("Populating definition");
        NodeList nodes = this.root.getChildNodes();
        for (int nodeIndex = 0; nodeIndex < nodes.getLength(); ++nodeIndex) {
            try {
                Node node = nodes.item(nodeIndex);
                if (node.getNodeType() == 3) continue;
                if (SERVICE.equals(node.getLocalName())) {
                    this.processServiceNode(node);
                }
                if (BINDING.equals(node.getLocalName())) {
                    this.processBindingNode(node);
                }
                if (PORT_TYPE.equals(node.getLocalName())) {
                    this.processPortType(node);
                }
                if (TYPES.equals(node.getLocalName())) {
                    this.processPortTypes(node);
                }
                if (!MESSAGE.equals(node.getLocalName())) continue;
                this.processMessage(node);
                continue;
            }
            catch (Exception ex) {
                logger.warning(ex.getMessage());
            }
        }
    }

    private void processMessage(Node node) throws DOMException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Message message = new Message();
        this.def.addMessage(message);
        this.populateAttributes(message, node);
        NodeList nodes = node.getChildNodes();
        for (int nodeIndex = 0; nodeIndex < nodes.getLength(); ++nodeIndex) {
            Node childNode = nodes.item(nodeIndex);
            if (childNode.getNodeType() == 3 || !PART.equals(childNode.getLocalName())) continue;
            Part part = new Part();
            message.getPart().add(part);
            this.populateAttributes(part, childNode);
        }
    }

    private void processPortTypes(Node node) throws DOMException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        NodeList nodes = node.getChildNodes();
        for (int nodeIndex = 0; nodeIndex < nodes.getLength(); ++nodeIndex) {
            Node childNode = nodes.item(nodeIndex);
            if (childNode.getNodeType() == 3 || !SCHEMA.equals(childNode.getLocalName())) continue;
            Schema schema = new Schema();
            this.def.getSchemas().add(schema);
            this.processSchema(schema, childNode);
        }
    }

    private void processSchema(Schema schema, Node node) throws DOMException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        NodeList nodes = node.getChildNodes();
        this.populateAttribute(schema, node, "targetNamespace");
        for (int nodeIndex = 0; nodeIndex < nodes.getLength(); ++nodeIndex) {
            Node childNode = nodes.item(nodeIndex);
            if (childNode.getNodeType() == 3) continue;
            if (ELEMENT.equals(childNode.getLocalName()) || SIMPLE_TYPE.equals(childNode.getLocalName()) || COMPLEX_TYPE.equals(childNode.getLocalName())) {
                ObjectType obj = new ObjectType();
                this.populateAttribute(obj, childNode, "name");
                this.populateAttribute(obj, childNode, "type");
                Object value = this.getAttribute(childNode, "abstract");
                if (value != null) {
                    obj.setIsAbstract((String)value);
                }
                if (childNode.hasChildNodes()) {
                    if (ELEMENT.equals(childNode.getLocalName())) {
                        this.processElement(obj, childNode);
                    } else if (COMPLEX_TYPE.equals(childNode.getLocalName())) {
                        this.processComplexType(obj, childNode);
                    } else if (SIMPLE_TYPE.equals(childNode.getLocalName())) {
                        this.processSimpleType(obj, childNode);
                    }
                }
                schema.getTypes().add(obj);
            }
            if (IMPORT.equals(childNode.getLocalName())) {
                this.processImport(childNode);
            }
            if (!INCLUDE.equals(childNode.getLocalName())) continue;
            this.processInclude(childNode);
        }
    }

    private void processImport(Node node) {
        try {
            for (int attributeIndex = 0; attributeIndex < node.getAttributes().getLength(); ++attributeIndex) {
                System.out.println(node.getAttributes().item(attributeIndex).getNodeName() + "=" + node.getAttributes().item(attributeIndex).getNodeValue());
                if (!node.getAttributes().item(attributeIndex).getNodeName().equals("schemaLocation")) continue;
                String path = node.getAttributes().item(attributeIndex).getNodeValue();
                File fXmlFile = new File(path);
                if (path.startsWith("http://")) {
                    URL url = new URL(path);
                    fXmlFile = new File(this.tempDir, fXmlFile.getName());
                    FileUtils.copyURLToFile((URL)url, (File)fXmlFile);
                    System.out.println(path);
                } else {
                    File temp = new File(this.paths.peek(), path);
                    fXmlFile = new File(this.tempDir, fXmlFile.getName());
                    FileUtils.copyURLToFile((URL)temp.toURL(), (File)fXmlFile);
                    System.out.println(temp.getAbsolutePath());
                }
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                dbFactory.setNamespaceAware(true);
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(fXmlFile);
                Element schemaRoot = doc.getDocumentElement();
                this.processSchema(new Schema(), schemaRoot);
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (DOMException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    private void processInclude(Node node) {
        for (int attributeIndex = 0; attributeIndex < node.getAttributes().getLength(); ++attributeIndex) {
            System.out.println(node.getAttributes().item(attributeIndex).getNodeName() + "=" + node.getAttributes().item(attributeIndex).getNodeValue());
        }
    }

    private void processSimpleType(ObjectType objectType, Node node) throws DOMException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        NodeList nodes = node.getChildNodes();
        for (int nodeIndex = 0; nodeIndex < nodes.getLength(); ++nodeIndex) {
            Node childNode = nodes.item(nodeIndex);
            if (childNode.getNodeType() == 3 || !COMPLEX_TYPE.equals(childNode.getLocalName())) continue;
            this.processComplexType(objectType, childNode);
        }
    }

    private void processElement(ObjectType objectType, Node node) throws DOMException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        NodeList nodes = node.getChildNodes();
        this.populateAttributes(objectType, node);
        for (int nodeIndex = 0; nodeIndex < nodes.getLength(); ++nodeIndex) {
            Node childNode = nodes.item(nodeIndex);
            if (childNode.getNodeType() == 3 || !RESTRICTION.equals(childNode.getLocalName())) continue;
            this.processComplexType(objectType, childNode);
        }
    }

    private void processComplexType(ObjectType objectType, Node node) throws DOMException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        NodeList nodes = node.getChildNodes();
        for (int nodeIndex = 0; nodeIndex < nodes.getLength(); ++nodeIndex) {
            Node seqElement;
            int element;
            NodeList seqElements;
            Node childNode = nodes.item(nodeIndex);
            if (childNode.getNodeType() == 3) continue;
            if (COMPLEX_CONTENT.equals(childNode.getLocalName())) {
                seqElements = childNode.getChildNodes();
                for (element = 0; element < seqElements.getLength(); ++element) {
                    seqElement = seqElements.item(element);
                    if (seqElement.getNodeType() == 3) continue;
                    if (EXTENSION.equals(seqElement.getLocalName())) {
                        this.populateAttributes(objectType, seqElement);
                        this.processComplexType(objectType, seqElement);
                        continue;
                    }
                    if (!RESTRICTION.equals(seqElement.getLocalName())) continue;
                    this.populateAttributes(objectType, seqElement);
                    this.processRestriction(objectType, seqElement);
                }
                continue;
            }
            if (!SEQUENCE.equals(childNode.getLocalName())) continue;
            seqElements = childNode.getChildNodes();
            for (element = 0; element < seqElements.getLength(); ++element) {
                seqElement = seqElements.item(element);
                if (seqElement.getNodeType() == 3) continue;
                ObjectType innerObjectType = new ObjectType();
                if (ELEMENT.equals(seqElement.getLocalName())) {
                    this.populateAttributes(innerObjectType, seqElement);
                }
                objectType.getInnerObjectType().add(innerObjectType);
            }
        }
    }

    private void processRestriction(ObjectType objectType, Node seqElement) {
    }

    private void processPortType(Node node) throws DOMException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        PortType portType = new PortType();
        this.def.getPortTypes().add(portType);
        this.populateAttributes(portType, node);
        NodeList nodes = node.getChildNodes();
        for (int nodeIndex = 0; nodeIndex < nodes.getLength(); ++nodeIndex) {
            Node childNode = nodes.item(nodeIndex);
            if (childNode.getNodeType() == 3 || !OPERATION.equals(childNode.getLocalName())) continue;
            Operation op = new Operation();
            portType.addOperation(op);
            this.populateAttributes(op, childNode);
            this.processOperation(op, childNode);
        }
    }

    private void processBindingNode(Node node) throws DOMException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Binding binding = new Binding();
        this.def.getBindings().add(binding);
        this.populateAttributes(binding, node);
        NodeList nodes = node.getChildNodes();
        for (int nodeIndex = 0; nodeIndex < nodes.getLength(); ++nodeIndex) {
            Node childNode = nodes.item(nodeIndex);
            if (childNode.getNodeType() == 3 || !OPERATION.equals(childNode.getLocalName())) continue;
            Operation op = new Operation();
            binding.addOperation(op);
            this.populateAttributes(op, childNode);
            this.processOperation(op, childNode);
        }
    }

    private void processOperation(Operation operation, Node node) throws DOMException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        NodeList nodes = node.getChildNodes();
        for (int nodeIndex = 0; nodeIndex < nodes.getLength(); ++nodeIndex) {
            Node childNode = nodes.item(nodeIndex);
            if (childNode.getNodeType() == 3) continue;
            if (INPUT.equals(childNode.getLocalName())) {
                this.processInput(childNode, operation);
            }
            if (OUTPUT.equals(childNode.getLocalName())) {
                this.processOutput(childNode, operation);
            }
            if (FAULT.equals(childNode.getLocalName())) {
                this.processFault(childNode, operation);
            }
            if (!DOCUMENTATION.equals(childNode.getLocalName())) continue;
            this.processDocumentation(childNode, operation);
        }
    }

    private void processDocumentation(Node node, Operation operation) {
        operation.setDocumentation(node.getTextContent());
    }

    private void processInput(Node node, Operation operation) throws DOMException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Input input = new Input();
        operation.setInput(input);
        this.populateAttributes(input, node);
        NodeList nodes = node.getChildNodes();
        for (int nodeIndex = 0; nodeIndex < nodes.getLength(); ++nodeIndex) {
            Node childNode = nodes.item(nodeIndex);
            if (childNode.getNodeType() == 3 || !HEADER.equals(childNode.getLocalName())) continue;
            Header header = new Header();
            input.addHeader(header);
            this.populateAttributes(header, childNode);
        }
    }

    private void processOutput(Node node, Operation operation) throws DOMException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Output output = new Output();
        operation.setOutput(output);
        this.populateAttributes(output, node);
    }

    private void processFault(Node node, Operation operation) throws DOMException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Fault fault = new Fault();
        operation.addFault(fault);
        this.populateAttributes(fault, node);
    }

    private void populateAttributes(Object entity, Node node) throws DOMException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        for (int attributeIndex = 0; attributeIndex < node.getAttributes().getLength(); ++attributeIndex) {
            try {
                PropertyUtils.setProperty((Object)entity, (String)node.getAttributes().item(attributeIndex).getNodeName(), (Object)node.getAttributes().item(attributeIndex).getNodeValue());
                continue;
            }
            catch (Exception ex) {
                System.out.println("Could not process attribute:" + node.getAttributes().item(attributeIndex).getNodeName() + ". Error:" + ex.getMessage());
            }
        }
    }

    private void populateAttribute(Object entity, Node node, String name) throws DOMException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        for (int attributeIndex = 0; attributeIndex < node.getAttributes().getLength(); ++attributeIndex) {
            if (!name.equals(node.getAttributes().item(attributeIndex).getNodeName())) continue;
            PropertyUtils.setProperty((Object)entity, (String)node.getAttributes().item(attributeIndex).getNodeName(), (Object)node.getAttributes().item(attributeIndex).getNodeValue());
            break;
        }
    }

    private Object getAttribute(Node node, String name) throws DOMException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        for (int attributeIndex = 0; attributeIndex < node.getAttributes().getLength(); ++attributeIndex) {
            if (!name.equals(node.getAttributes().item(attributeIndex).getNodeName())) continue;
            return node.getAttributes().item(attributeIndex).getNodeValue();
        }
        return null;
    }

    private void processServiceNode(Node node) throws DOMException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Service service = new Service();
        this.def.getServices().add(service);
        this.populateAttributes(service, node);
        NodeList nodes = node.getChildNodes();
        for (int nodeIndex = 0; nodeIndex < nodes.getLength(); ++nodeIndex) {
            Node childNode = nodes.item(nodeIndex);
            if (childNode.getNodeType() == 3) continue;
            if (PORT.equals(childNode.getLocalName())) {
                Port port = new Port();
                service.addPort(port);
                this.populateAttributes(port, childNode);
                this.processPortNode(childNode, port);
            }
            if (!DOCUMENTATION.equals(childNode.getLocalName())) continue;
            service.setDocumentation(childNode.getTextContent());
        }
    }

    private void processPortNode(Node node, Port port) throws DOMException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        NodeList nodes = node.getChildNodes();
        for (int nodeIndex = 0; nodeIndex < nodes.getLength(); ++nodeIndex) {
            Node childNode = nodes.item(nodeIndex);
            if (childNode.getNodeType() == 3 || !ADDRESS.equals(childNode.getLocalName())) continue;
            this.processAddress(childNode, port);
        }
    }

    private void processAddress(Node node, Port port) throws DOMException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Address address = new Address();
        port.setAddress(address);
        this.populateAttributes(address, node);
    }

    private void loadWsdlDoc(String path) throws ParserConfigurationException, SAXException, IOException {
        logger.info("Loading WSDL");
        File fXmlFile = new File(path);
        if (path.startsWith("http://")) {
            URL url = new URL(path);
            this.paths.push(url.getPath() + ".wsdl");
            this.tempDir = new File(System.getProperty("java.io.tmpdir"));
            fXmlFile = new File(this.tempDir, url.getPath() + ".wsdl");
            FileUtils.copyURLToFile((URL)url, (File)fXmlFile);
            System.out.println(this.paths.peek());
        }
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setNamespaceAware(true);
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(fXmlFile);
        this.root = doc.getDocumentElement();
    }
}

