package org.mule.devkit.wsdl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefinitionDiff implements Diff<String,Definition>{

	public String getDiff(Definition firstObject, Definition secondObject) {
		StringBuilder output = new StringBuilder();
		
		
		Map<String,Service> first = populateMap(firstObject.getServices());
		Map<String,Service> second = populateMap(secondObject.getServices());
		serviceDiff(firstObject, secondObject, output, first, second);
		serviceDiff(secondObject, firstObject, output, second, first);
		
		Map<String,Binding> firstOp = populateMap(firstObject.getBindings());
		Map<String,Binding> secondOp = populateMap(secondObject.getBindings());
		diffBinding(firstObject, secondObject, output, firstOp, secondOp);
		diffBinding(secondObject,firstObject, output, secondOp,firstOp);
		
		Map<String,Schema> firstSch = populateMap(firstObject.getSchemas());
		Map<String,Schema> secondSch = populateMap(secondObject.getSchemas());
		
		diffSchema(firstObject, secondObject, output, firstSch, secondSch);
		diffSchema(secondObject,firstObject, output, secondSch,firstSch);
		
		return output.toString();
	}

	private void diffSchema(Definition firstObject, Definition secondObject,
			StringBuilder output, Map<String, Schema> secondSch,
			Map<String, Schema> firstSch) {
		for(String key : firstSch.keySet()){
			if(secondSch.containsKey(key)){
				Map<String,ObjectType> firstOpp = populateMap(firstSch.get(key).getTypes());
				Map<String,ObjectType> secondOpp = populateMap(secondSch.get(key).getTypes());
				for(String keyop : firstOpp.keySet()){
					if(secondOpp.containsKey(keyop)){
						
						Map<String,ObjectType> firstElement = populateMap(firstOpp.get(keyop).getInnerObjectType());
						Map<String,ObjectType> seconElement = populateMap(secondOpp.get(keyop).getInnerObjectType());
						for(String keyType : firstElement.keySet()){
							if(seconElement.containsKey(keyType)){
								continue;
								
							}
								
							output.append("++++"+getFormattedOutput(firstObject,secondObject) +"\t"+keyop+"\tField: "+keyType+"\n");
							output.append("----"+getFormattedOutput(secondObject,firstObject) +"\t"+keyop+"\tField: "+keyType+"\n");
						}
						continue;
					}
						
					output.append("++++"+getFormattedOutput(secondObject,firstObject) +"\tType: "+keyop+"\n");
					output.append("----"+getFormattedOutput(firstObject,secondObject) +"\tType: "+keyop+"\n");
				}
				continue;
			}
				
			output.append("++++"+getFormattedOutput(firstObject,secondObject) +"\tService: "+key+"\n");
			output.append("----"+getFormattedOutput(secondObject,firstObject) +"\tService: "+key+"\n");
		}
		
	}

	private String getFormattedOutput(Definition firstObject, Definition secondObject){
		StringBuilder builder = new StringBuilder();
		int maxsize = firstObject.getId().length() > secondObject.getId().length()  ? firstObject.getId().length() : secondObject.getId().length();
		builder.append(firstObject.getId());
		while(builder.length()<maxsize){
			builder.append(" ");
		}
		return builder.toString();
	}
	protected void serviceDiff(Definition firstObject, Definition secondObject,
			StringBuilder output, Map<String, Service> first,
			Map<String, Service> second) {
		for(String key : first.keySet()){
			if(second.containsKey(key))
				continue;
			output.append("++++"+firstObject.getId() +" Service: "+key+"\n");
			output.append("----"+secondObject.getId() +" Service: "+key+"\n");
		}
	}
	
	protected void diffBinding(Definition firstObject, Definition secondObject,
			StringBuilder output, Map<String, Binding> firstOp,
			Map<String, Binding> secondOp) {
		for(String key : firstOp.keySet()){
			if(secondOp.containsKey(key)){
				Map<String,Operation> firstOpp = populateMap(firstOp.get(key).getOperations());
				Map<String,Operation> secondOpp =populateMap(secondOp.get(key).getOperations());
				for(String keyop : firstOpp.keySet()){
					if(secondOpp.containsKey(keyop)){
						continue;
					}
						
					output.append("++++"+getFormattedOutput(firstObject,secondObject)  +"\tOperation: "+keyop+"\n");
					output.append("----"+getFormattedOutput(secondObject,firstObject) +"\tOperation: "+keyop+"\n");
				}
				continue;
			}
				
			output.append("++++"+firstObject.getId() +"\tService:\t"+key+"\n");
			output.append("----"+secondObject.getId() +"\tService:\t"+key+"\n");
		}
	}
	private <T extends Identifiable> Map<String,T> populateMap(List<T> list){
		Map<String,T> map = new HashMap<String,T>();
		for(T t: list){
			map.put(t.getId(),t);
		}
		return map;
	}

}
