package org.mule.devkit.unmapper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize.Inclusion;

public class Unmapper {
	private static ObjectMapper mapper = new ObjectMapper();

	static{
		mapper.setSerializationInclusion(Inclusion.NON_NULL);
		mapper.setSerializationInclusion(Inclusion.NON_DEFAULT);
	}
	@SuppressWarnings("unchecked")
	public static <T> T populate(Class<?> clazz, Map<String, Object> attributes) {
		Object instance;

		instance = mapper.convertValue(attributes, clazz);

		return (T) instance;

	}

	@SuppressWarnings("unchecked")
	public static <T> List<T> populateList(Class<?> clazz,
			List<Map<String, Object>> attributesList) {

		List<T> list = new ArrayList<T>();

		for (Map<String, Object> attributes : attributesList) {
			Object instance = populate(clazz, attributes);
			list.add((T) instance);
		}
		return (List<T>) list;

	}
	
	public static Map<String,Object> toMap(Object object){
		return (Map<String,Object>)mapper.convertValue(object, Map.class); 
	}
}
