/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.model.studio;

import javax.xml.bind.annotation.*;

/**
 * <element-query orderBy="enabled|disabled" offset="enabled|disabled" limit="enabled|disabled"
 * nativeQuery="enabled|disabled" orOperator="enabled|disabled" andOperator="enabled|disabled"
 * associatedConfig="config-ref" required="true" description="Type of object to create." caption="sObject Type" name="type"></element-query>
 */

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "QueryType")
public class QueryType extends AttributeType {

    @XmlAttribute(name = "associatedConfig")
    protected String associatedConfig;
    @XmlAttribute(required = true)
    protected String andOperator;
    @XmlAttribute(required = true)
    protected String orOperator;
    @XmlAttribute(required = true)
    protected String nativeQuery;
    @XmlAttribute(required = true)
    protected String limit;
    @XmlAttribute(required = true)
    protected String offset;
    @XmlAttribute(required = true)
    protected String orderBy;

    public String getAssociatedConfig() {
        return associatedConfig;
    }

    public void setAssociatedConfig(String associatedConfig) {
        this.associatedConfig = associatedConfig;
    }

    public String getAndOperator() {
        return andOperator;
    }

    public void setAndOperator(String andOperator) {
        this.andOperator = andOperator;
    }

    public String getOrOperator() {
        return orOperator;
    }

    public void setOrOperator(String orOperator) {
        this.orOperator = orOperator;
    }

    public String getNativeQuery() {
        return nativeQuery;
    }

    public void setNativeQuery(String nativeQuery) {
        this.nativeQuery = nativeQuery;
    }

    public String getLimit() {
        return limit;
    }

    public void setLimit(String limit) {
        this.limit = limit;
    }

    public String getOffset() {
        return offset;
    }

    public void setOffset(String offset) {
        this.offset = offset;
    }

    public String getOrderBy() {
        return orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

}