/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.studio;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public class NamespaceFilter
extends XMLFilterImpl {
    private String usedNamespaceUri;
    private String prefix;
    private boolean addNamespace;
    private boolean addedNamespace;

    public NamespaceFilter(String prefix, String namespaceUri, boolean addNamespace) {
        if (addNamespace) {
            this.prefix = prefix;
            this.usedNamespaceUri = namespaceUri;
        } else {
            this.prefix = "";
            this.usedNamespaceUri = "";
        }
        this.addNamespace = addNamespace;
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        if (this.addNamespace) {
            this.startControlledPrefixMapping();
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        super.startElement(this.usedNamespaceUri, localName, qName, atts);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(this.usedNamespaceUri, localName, qName);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        super.startPrefixMapping(prefix, uri);
        if (this.addNamespace) {
            this.startControlledPrefixMapping();
        }
    }

    private void startControlledPrefixMapping() throws SAXException {
        if (this.addNamespace && !this.addedNamespace) {
            super.startPrefixMapping(this.prefix, this.usedNamespaceUri);
            this.addedNamespace = true;
        }
    }
}

