package org.mule.devkit.model.studio.libraries;

import org.apache.commons.collections.CollectionUtils;

import javax.xml.bind.annotation.*;
import java.util.List;


@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "require", namespace = "http://www.mulesoft.org/schema/mule/tooling.attributes")
public class RequiredLibraries {

    @XmlElement( name = "jar", namespace = "http://www.mulesoft.org/schema/mule/tooling.attributes")
    List<JarElement> jars;

    @XmlElement( name = "nativeLib", namespace = "http://www.mulesoft.org/schema/mule/tooling.attributes")
    List<NativeLibElement> libs;

    @XmlElement( name = "or", namespace = "http://www.mulesoft.org/schema/mule/tooling.attributes")
    List<OptionalLibs> optionals;

    public List<JarElement> getJars() {
        return jars;
    }

    public void setJars(List<JarElement> jars) {
        this.jars = jars;
    }

    public List<NativeLibElement> getLibs() {
        return libs;
    }

    public void setLibs(List<NativeLibElement> libs) {
        this.libs = libs;
    }

    public List<OptionalLibs> getOptional() {
        return optionals;
    }

    public void setOptional(List<OptionalLibs> optionals) {
        this.optionals = optionals;
    }

    public boolean hasElements(){
        return !CollectionUtils.isEmpty(jars) ||
               !CollectionUtils.isEmpty(libs) ||
               !CollectionUtils.isEmpty(optionals);
    }

}
