/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.studio;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.mule.devkit.model.code.CodeWriter;
import org.mule.devkit.model.studio.AbstractElementType;
import org.mule.devkit.model.studio.EditorModel;
import org.mule.devkit.model.studio.NamespaceType;
import org.mule.devkit.model.studio.PatternType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StudioModel {
    private CodeWriter codeWriter;
    private Map<String, EditorModel> editorModels;

    public StudioModel(CodeWriter codeWriter) {
        this.codeWriter = codeWriter;
        this.editorModels = new HashMap<String, EditorModel>();
    }

    public void build() throws IOException {
        try {
            for (EditorModel studioXMLSerializer : this.editorModels.values()) {
                studioXMLSerializer.serializeXml();
            }
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException(e);
        }
    }

    public void addNamespaceType(String moduleName, String outputFileName) {
        this.getOrCreateEditorModel(moduleName).setOutputFileName(outputFileName);
    }

    private EditorModel getOrCreateEditorModel(String moduleName) {
        EditorModel editorModel = this.editorModels.get(moduleName);
        if (editorModel == null) {
            editorModel = new EditorModel(this.codeWriter);
            this.editorModels.put(moduleName, editorModel);
        }
        return editorModel;
    }

    public NamespaceType getOrCreateNamespace(String moduleName) {
        return this.getOrCreateEditorModel(moduleName).getNamespaceType();
    }

    public void addPatternTypeOperation(String moduleName, BuilderWithArgs<Boolean, JAXBElement<PatternType>> patternTypeOperationsChooser) {
        this.getOrCreateEditorModel(moduleName).setPatternTypeOperationsBuilder(patternTypeOperationsChooser);
    }

    public void addIsOAuth(String moduleName, boolean isOAuth) {
        this.getOrCreateEditorModel(moduleName).setOAuth(isOAuth);
    }

    public void addConfigBuilderRef(String moduleName, ConfigRefBuilder<JAXBElement<? extends AbstractElementType>> builder) {
        this.getOrCreateEditorModel(moduleName).setConfigRefBuilder(builder);
    }

    public ConfigRefBuilder<JAXBElement<? extends AbstractElementType>> getConfigBuilderRef(String moduleName) {
        return this.getOrCreateEditorModel(moduleName).getConfigRefBuilder();
    }

    public void addProcessorMethods(String moduleName, BuilderWithArgs<Boolean, List<JAXBElement<? extends AbstractElementType>>> processProcessorMethodsChooser) {
        this.getOrCreateEditorModel(moduleName).addProcessorOperations(processProcessorMethodsChooser);
    }

    public void addNestedElements(String moduleName, Builder<List<JAXBElement<? extends AbstractElementType>>> nestedElementsBuilder) {
        this.getOrCreateEditorModel(moduleName).addNestedElements(nestedElementsBuilder);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface BuilderWithArgs<U, T> {
        public T build(U var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Builder<T> {
        public T build();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ConfigRefBuilder<T>
    extends Builder<T> {
        public void addRequiredType(String var1);
    }
}

