/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.studio;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.mule.devkit.model.code.CodeWriter;
import org.mule.devkit.model.studio.AbstractElementType;
import org.mule.devkit.model.studio.NamespaceFilter;
import org.mule.devkit.model.studio.NamespaceType;
import org.mule.devkit.model.studio.PatternType;
import org.mule.devkit.model.studio.StudioModel;
import org.xml.sax.ContentHandler;

public class EditorModel {
    private StudioModel.ConfigRefBuilder<JAXBElement<? extends AbstractElementType>> configRefBuilder;
    private StudioModel.BuilderWithArgs<Boolean, JAXBElement<PatternType>> patternTypeOperationsBuilder;
    private boolean isOAuth;
    private String outputFileName;
    private NamespaceType namespaceType;
    private List<StudioModel.BuilderWithArgs<Boolean, List<JAXBElement<? extends AbstractElementType>>>> listOfOperations;
    private List<StudioModel.Builder<List<JAXBElement<? extends AbstractElementType>>>> listOfComplexTypesBuilders;
    private CodeWriter codeWriter;

    public EditorModel(CodeWriter codeWriter) {
        this.codeWriter = codeWriter;
        this.namespaceType = new NamespaceType();
        this.listOfOperations = new ArrayList<StudioModel.BuilderWithArgs<Boolean, List<JAXBElement<? extends AbstractElementType>>>>();
        this.listOfComplexTypesBuilders = new ArrayList<StudioModel.Builder<List<JAXBElement<? extends AbstractElementType>>>>();
        this.isOAuth = false;
    }

    public StudioModel.ConfigRefBuilder<JAXBElement<? extends AbstractElementType>> getConfigRefBuilder() {
        return this.configRefBuilder;
    }

    public void setConfigRefBuilder(StudioModel.ConfigRefBuilder<JAXBElement<? extends AbstractElementType>> configRefBuilder) {
        this.configRefBuilder = configRefBuilder;
    }

    public void setPatternTypeOperationsBuilder(StudioModel.BuilderWithArgs<Boolean, JAXBElement<PatternType>> patternTypeOperationsBuilder) {
        this.patternTypeOperationsBuilder = patternTypeOperationsBuilder;
    }

    public NamespaceType getNamespaceType() {
        return this.namespaceType;
    }

    public void setOAuth(boolean OAuth) {
        this.isOAuth = OAuth;
    }

    public void setOutputFileName(String outputFileName) {
        this.outputFileName = outputFileName;
    }

    public void addProcessorOperations(StudioModel.BuilderWithArgs<Boolean, List<JAXBElement<? extends AbstractElementType>>> operations) {
        this.listOfOperations.add(operations);
    }

    public void addNestedElements(StudioModel.Builder<List<JAXBElement<? extends AbstractElementType>>> nestedElements) {
        this.listOfComplexTypesBuilders.add(nestedElements);
    }

    public void serializeXml() throws JAXBException, IOException {
        if (this.outputFileName == null) {
            throw new IllegalStateException("Error: Can't generate XML. outputFileName has not been specified.");
        }
        this.namespaceType.getConnectorOrEndpointOrGlobal().add((JAXBElement<? extends AbstractElementType>)this.configRefBuilder.build());
        this.namespaceType.getConnectorOrEndpointOrGlobal().add(this.patternTypeOperationsBuilder.build(this.isOAuth));
        this.addOnlyOnce(this.mapArgsBuilderToBuilder(this.isOAuth, this.listOfOperations));
        this.addOnlyOnce(this.listOfComplexTypesBuilders);
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{NamespaceType.class});
        Marshaller marshaller = jaxbContext.createMarshaller();
        NamespaceFilter outFilter = new NamespaceFilter("mule", "http://www.mulesoft.org/schema/mule/core", true);
        OutputFormat format = new OutputFormat();
        format.setIndent(true);
        format.setNewlines(true);
        OutputStream schemaStream = this.codeWriter.openBinary(null, this.outputFileName);
        XMLWriter writer = new XMLWriter(schemaStream, format);
        outFilter.setContentHandler((ContentHandler)writer);
        marshaller.marshal((Object)this.namespaceType, (ContentHandler)outFilter);
    }

    private <U, T> List<StudioModel.Builder<T>> mapArgsBuilderToBuilder(U arg, List<StudioModel.BuilderWithArgs<U, T>> builderWithArgsList) {
        ArrayList<StudioModel.Builder<T>> builders = new ArrayList<StudioModel.Builder<T>>();
        for (StudioModel.BuilderWithArgs<U, T> builderWithArgs : builderWithArgsList) {
            builders.add(new BuilderWithNoArgsAdapter<U, T>(arg, builderWithArgs));
        }
        return builders;
    }

    private void addOnlyOnce(List<StudioModel.Builder<List<JAXBElement<? extends AbstractElementType>>>> builders) {
        HashSet<String> elementsAlreadyAdded = new HashSet<String>();
        for (StudioModel.Builder<List<JAXBElement<? extends AbstractElementType>>> elements : builders) {
            List<JAXBElement<? extends AbstractElementType>> elementList = elements.build();
            Collections.sort(elementList, new Comparator<JAXBElement<? extends AbstractElementType>>(){

                @Override
                public int compare(JAXBElement<? extends AbstractElementType> a, JAXBElement<? extends AbstractElementType> b) {
                    return ((AbstractElementType)a.getValue()).getLocalId().compareTo(((AbstractElementType)b.getValue()).getLocalId());
                }
            });
            for (JAXBElement<? extends AbstractElementType> element : elementList) {
                String localId = ((AbstractElementType)element.getValue()).getLocalId();
                if (elementsAlreadyAdded.contains(localId)) continue;
                this.namespaceType.getConnectorOrEndpointOrGlobal().add(element);
                elementsAlreadyAdded.add(localId);
            }
        }
    }

    private static class BuilderWithNoArgsAdapter<U, T>
    implements StudioModel.Builder<T> {
        private StudioModel.BuilderWithArgs<U, T> builderWithArgs;
        private U arg;

        public BuilderWithNoArgsAdapter(U arg, StudioModel.BuilderWithArgs<U, T> builderWithArgs) {
            this.builderWithArgs = builderWithArgs;
            this.arg = arg;
        }

        @Override
        public T build() {
            return this.builderWithArgs.build(this.arg);
        }
    }
}

