/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package org.mule.devkit.internal.ws.connection;

import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.security.oauth.callback.ProcessCallback;

public class DefaultProcessTemplate<P, Adapter> implements ProcessTemplate<P, Adapter> {

    private final Adapter processObject;

    public DefaultProcessTemplate(Adapter adapter) {
        processObject = adapter;
    }

    public P execute(ProcessCallback<P, Adapter> processCallback, MessageProcessor messageProcessor, MuleEvent event)
        throws Exception
    {
        return processCallback.process(processObject);
    }

    public P execute(ProcessCallback<P, Adapter> processCallback, Filter filter, MuleMessage message)
        throws Exception
    {
        return processCallback.process(processObject);
    }

}
