/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.api.transformer;

import org.mule.api.transformer.DataType;

public class DefaultTranformingValue<V, D> implements TransformingValue<V, DataType<D>> {

    private V value;
    private DataType<D> dataType;

    public DefaultTranformingValue(V value, DataType<D> dataType) {
        this.value = value;
        this.dataType = dataType;
    }

    @Override
    public V getValue() {
        return value;
    }

    @Override
    public DataType<D> getDataType() {
        return dataType;
    }
}
