/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.internal.lic.model;

import org.apache.commons.lang.StringUtils;

/**
 * @author MuleSoft, Inc
 */
public class Entitlement {

    public static final String DEFAULT_PROVIDER = "MuleSoft";

    private final String id;
    private final String description;
    private String provider = DEFAULT_PROVIDER;
    private String licName = "";
    private String version = "";

    public Entitlement(String id, String description) {
        this.id = id;
        this.description = description;
    }

    public Entitlement(String id, String description, String provider, String licName, String version) {
        this.id = id;
        this.description = description;
        this.provider = provider;
        this.licName = licName;
        this.version = version;
    }

    public boolean isThirdParty() {
        return !StringUtils.equals(provider, DEFAULT_PROVIDER);
    }

    public String id() {
        return id;
    }

    public String description() {
        return description;
    }

    public String provider() {
        return provider;
    }

    public String licenseName() {
        return licName;
    }

    public String version() {
        return version;
    }
}
