/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.internal.ws.model;

import org.mule.api.MuleEvent;
import org.mule.api.debug.DebugInfoProvider;
import org.mule.api.debug.FieldDebugInfo;
import org.mule.api.debug.FieldDebugInfoFactory;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transformer.TransformerMessagingException;
import org.mule.api.transport.PropertyScope;
import org.mule.transport.NullPayload;

import java.util.ArrayList;
import java.util.List;

import static org.mule.module.ws.consumer.WSConsumer.SOAP_HEADERS_PROPERTY_PREFIX;

public class InvokeSoapMessageProcessorDebuggable extends InvokeSoapMessageProcessor implements DebugInfoProvider {

    public InvokeSoapMessageProcessorDebuggable(String operationName) {
        super(operationName);
    }

    @Override
    public List<FieldDebugInfo<?>> getDebugInfo(MuleEvent event) {
        List<FieldDebugInfo<?>> infoList = new ArrayList<FieldDebugInfo<?>>();

        try {
            if (event.getMessage().getPayload() instanceof NullPayload) {
                infoList.add(FieldDebugInfoFactory.createFieldDebugInfo("Body", NullPayload.class, "{NullPayload}"));
            } else {
                final String xml = (String) evaluateAndTransform(muleContext, event, String.class, null, event.getMessage().getPayload());
                event.getMessage().setPayload(xml, event.getMessage().getDataType());
                infoList.add(FieldDebugInfoFactory.createFieldDebugInfo("Body", String.class, removeXMLHeader(xml)));
            }
        } catch (Exception e) {
            infoList.add(FieldDebugInfoFactory.createFieldDebugInfo("Header", String.class, e));
        }
        try {
            final List<String> soapHeaders = soapHeaders(event);
            if (!soapHeaders.isEmpty()) {
                final StringBuilder sb = new StringBuilder();
                for (String soapHeader : soapHeaders) {
                    sb.append(removeXMLHeader(soapHeader));
                    sb.append("\n");
                }
                infoList.add(FieldDebugInfoFactory.createFieldDebugInfo("Headers", String.class, sb.toString()));
            }
        } catch (Exception e) {
            infoList.add(FieldDebugInfoFactory.createFieldDebugInfo("Header", String.class, e));
        }

        return infoList;
    }

    private String removeXMLHeader(String xml) {
        return xml.replaceAll("<\\?xml(.+?)\\?>", "").trim();
    }

    private List<String> soapHeaders(MuleEvent event) throws TransformerException, TransformerMessagingException {
        List<String> headers = new ArrayList<String>();

        for (String outboundPropertyName : event.getMessage().getOutboundPropertyNames()) {
            if (outboundPropertyName.startsWith(SOAP_HEADERS_PROPERTY_PREFIX)) {
                final String headerXml = (String) evaluateAndTransform(muleContext, event, String.class, null, event.getMessage().getOutboundProperty(outboundPropertyName));
                final DataType<?> propertyDataType = event.getMessage().getPropertyDataType(outboundPropertyName, PropertyScope.OUTBOUND);
                event.getMessage().setOutboundProperty(outboundPropertyName, headerXml, propertyDataType);
                headers.add(headerXml);
            }
        }
        return headers;
    }
}
