/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.internal.ws.common;

import com.google.common.base.Optional;
import org.mule.devkit.api.ws.authentication.WsdlSecurityStrategy;
import org.mule.devkit.api.ws.definition.ServiceDefinition;
import org.mule.devkit.api.ws.transport.WsdlTransport;
import org.mule.devkit.internal.connection.management.ConnectionManagementConnectorAdapter;
import org.mule.devkit.internal.ws.model.SoapBodyEnricher;
import org.w3c.dom.Document;

import java.util.List;

public interface WsdlAdapter extends ConnectionManagementConnectorAdapter {

    List<ServiceDefinition> serviceDefinitions() throws Exception;

    String endpoint(ServiceDefinition serviceDefinition) throws Exception;

    List<WsdlSecurityStrategy> security(ServiceDefinition serviceDefinition) throws Exception;

    WsdlTransport transport(ServiceDefinition serviceDefinition) throws Exception;

    Optional<List<Document>> headers(ServiceDefinition serviceDefinition, String operationName) throws Exception;

    Optional<? extends SoapBodyEnricher> bodyEnricher();

    WSResolver wsResolver() throws Exception;

    Optional<String> singleServiceDefinitionId() throws Exception;

    String wsdlSeparator();

    void handleException(Exception e) throws Exception;

    List<Class<? extends Exception>> managedExceptions();
}
