/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.internal.metadata;

import org.apache.commons.lang.StringUtils;
import org.mule.common.metadata.DefaultMetaDataKey;
import org.mule.common.metadata.MetaDataKey;
import org.mule.devkit.api.metadata.ComposedMetaDataKey;
import org.mule.devkit.api.metadata.ComposedMetaDataKeyBuilder;
import org.mule.devkit.api.metadata.exception.InvalidSeparatorException;

import java.util.LinkedList;
import java.util.List;

/**
 * @author Mulesoft, Inc
 */
public class InternalComposedMetaDataKeyBuilder extends ComposedMetaDataKeyBuilder {

    private InternalComposedMetaDataKeyBuilder() {
        super();
    }

    public static ComposedMetaDataKey newKey() {
        return new DefaultComposedMetaDataKey();
    }

    public static ComposedMetaDataKey newKey(String separator) {
        return new DefaultComposedMetaDataKey(separator);
    }

    public static InternalComposedMetaDataKeyBuilder getInstance() {
        return new InternalComposedMetaDataKeyBuilder();
    }

    public static ComposedMetaDataKey fromSimpleKey(MetaDataKey defaultKey, String separator) {
        return new DefaultComposedMetaDataKey(defaultKey, separator);
    }

    public static MetaDataKey toSimpleKey(ComposedMetaDataKey composedKey, String keySeparator) {
        DefaultMetaDataKey metaDataKey = new DefaultMetaDataKey(composedKey.getId(keySeparator), composedKey.getDisplayName(keySeparator), composedKey.getProperties());
        metaDataKey.setCategory(composedKey.getCategory());
        return metaDataKey;
    }

    public static List<MetaDataKey> toSimpleKey(List<ComposedMetaDataKey> composedKeys, String keySeparator) {
        List<MetaDataKey> defaultMetaDataKeys = new LinkedList<MetaDataKey>();
        for (ComposedMetaDataKey metaDataKey : composedKeys) {
            defaultMetaDataKeys.add(toSimpleKey(metaDataKey, keySeparator));
        }
        return defaultMetaDataKeys;
    }

    public CombinationBuilder newKeyCombination() {
        return super.newKeyCombination();
    }

    public InternalComposedMetaDataKeyBuilder withSeparator(String keySeparator) {
        if (!StringUtils.isBlank(keySeparator)) {
            this.customSeparator = keySeparator;
            return this;
        }
        throw new InvalidSeparatorException("A MetaDataKey separator cannot be empty");
    }

}
