/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.internal.ws.model.cache;

import org.mule.api.MuleContext;
import org.mule.devkit.api.lifecycle.LifeCycleManager;
import org.mule.module.ws.consumer.WSConsumer;
import org.mule.module.ws.consumer.WSConsumerConfig;

import java.util.concurrent.Callable;

public class WSConsumerCallable implements Callable<WSConsumer> {

    private MuleContext muleContext;
    private WSConsumerConfig wsConsumerConfig;
    private String operation;

    public WSConsumerCallable(MuleContext muleContext, WSConsumerConfig wsConsumerConfig, String operation) {
        this.muleContext = muleContext;
        this.wsConsumerConfig = wsConsumerConfig;
        this.operation = operation;
    }

    @Override
    public WSConsumer call() throws Exception {
        WSConsumer wsConsumer = new WSConsumer();
        wsConsumer.setMuleContext(muleContext);
        wsConsumer.setConfig(wsConsumerConfig);
        wsConsumer.setOperation(operation);
        LifeCycleManager.executeInitialiseAndStart(wsConsumer);
        return wsConsumer;
    }
}
