/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.api.metadata;

import com.google.common.base.Optional;

import java.io.Serializable;
import java.util.Map;

/**
 * @author MuleSoft, Inc
 *
 * Interface to be implemented by any class that will work as a cache for MetaData retrieval on MetaDataCategories.
 * This Cache intialization and eviction will respond to the events declared in {@link org.mule.common.MetaDataCacheAware}
 *
 */
public interface ConnectorMetaDataCache {

    void put(Serializable key, Serializable value);

    void putAll(Map<? extends Serializable,? extends Serializable> values);

    <T> Optional<T> get(Serializable key);
}
