/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.api.ws.transport;

public class HttpBasicWsdlTransport implements WsdlTransport {

    private String user;
    private String pass;
    private boolean preemptive;

    public HttpBasicWsdlTransport(String user, String pass) {
        this(user, pass, false);
    }

    public HttpBasicWsdlTransport(String user, String pass, boolean preemptive) {
        this.user = user;
        this.pass = pass;
        this.preemptive = preemptive;
    }

    public String getUser() {
        return user;
    }

    public String getPass() {
        return pass;
    }

    public boolean isPreemptive() {
        return preemptive;
    }
}
