/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.internal.connection.management;

import org.mule.api.ConnectionException;

/**
 * @author Mulesoft, Inc
 *         <p/>
 *         Implementing of this interface will be called for connection testing.
 *         The method annotated with {@link @TestConnectivity} in the strategy will be used as implementation.
 */
public interface TestableConnection<K extends ConnectionManagementConnectionKey> {

    public void test(K connectionKey) throws ConnectionException;

}
