/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.internal.lic;

import org.mule.devkit.internal.lic.validator.DevkitLicenseValidator;
import org.mule.devkit.internal.lic.validator.LicenseValidator;
import org.mule.devkit.internal.lic.validator.TestValidator;

/**
 * @author Mulesoft, Inc
 */
public abstract class LicenseValidatorFactory {

    private static final String MULE_TESTING_MODE = "mule.testingMode";

    public static LicenseValidator getValidator(String moduleName) {
        return isTestMode() ? new TestValidator() : new DevkitLicenseValidator(moduleName);
    }

    private static boolean isTestMode() {
        return System.getProperty(MULE_TESTING_MODE) != null;
    }

}
