/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.internal.ws.model.cache;

import java.util.List;
import java.util.concurrent.Callable;
import javax.wsdl.Definition;
import javax.wsdl.Service;
import org.mule.devkit.api.ws.authentication.WsdlSecurityStrategy;
import org.mule.devkit.api.ws.definition.ServiceDefinition;
import org.mule.devkit.api.ws.transport.WsdlTransport;
import org.mule.devkit.internal.ws.common.DefaultEnhancedServiceDefinition;
import org.mule.devkit.internal.ws.common.EnhancedServiceDefinition;
import org.mule.devkit.internal.ws.common.WsdlAdapter;
import org.mule.devkit.internal.ws.common.WsdlUtils;
import org.mule.devkit.internal.ws.model.WsdlIntrospecterUtils;

public class EnhancedServiceDefinitionCallable
implements Callable<EnhancedServiceDefinition> {
    private WsdlAdapter wsdlAdapter;
    private ServiceDefinition serviceDefinition;
    private String operation;

    public EnhancedServiceDefinitionCallable(WsdlAdapter wsdlAdapter, ServiceDefinition serviceDefinition, String operation) {
        this.wsdlAdapter = wsdlAdapter;
        this.serviceDefinition = serviceDefinition;
        this.operation = operation;
    }

    @Override
    public EnhancedServiceDefinition call() throws Exception {
        String serviceAddress = this.wsdlAdapter.resolveAddress(this.serviceDefinition);
        WsdlTransport transport = this.wsdlAdapter.transport(this.serviceDefinition);
        return this.enhanceServiceDefinition(this.serviceDefinition, serviceAddress, this.wsdlAdapter.strategies(), transport, this.operation);
    }

    private EnhancedServiceDefinition enhanceServiceDefinition(ServiceDefinition serviceDefinition, String serviceAddress, List<WsdlSecurityStrategy> strategies, WsdlTransport transport, String operation) {
        Definition definition;
        String serviceName = (String)serviceDefinition.getService().orNull();
        String portName = (String)serviceDefinition.getPort().orNull();
        if (!serviceDefinition.getService().isPresent()) {
            definition = WsdlUtils.parseWSDL(serviceDefinition.getWsdlUrl().toString());
            serviceName = WsdlIntrospecterUtils.resolveServiceName(serviceDefinition, definition);
        }
        if (!serviceDefinition.getPort().isPresent()) {
            definition = WsdlUtils.parseWSDL(serviceDefinition.getWsdlUrl().toString());
            Service service = WsdlIntrospecterUtils.resolveService(serviceDefinition, definition);
            portName = WsdlIntrospecterUtils.resolvePortName(serviceDefinition, service, definition);
        }
        return new DefaultEnhancedServiceDefinition(serviceDefinition.getId(), serviceDefinition.getWsdlUrl(), serviceName, portName, serviceAddress, strategies, transport, operation);
    }
}

