/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.internal.ws.metadata;

import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.mule.common.DefaultResult;
import org.mule.common.FailureType;
import org.mule.common.Result;
import org.mule.common.metadata.DefaultMetaData;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.DefaultUnknownMetaDataModel;
import org.mule.common.metadata.DefaultXmlMetaDataModel;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataFailureType;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.MetaDataModelProperty;
import org.mule.common.metadata.MetaDataPropertyScope;
import org.mule.common.metadata.builder.DefaultMetaDataBuilder;
import org.mule.common.metadata.builder.XmlMetaDataBuilder;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.metadata.field.property.MetaDataFieldProperty;
import org.mule.common.metadata.key.property.TypeDescribingProperty;
import org.mule.common.metadata.property.StructureIdentifierMetaDataModelProperty;
import org.mule.devkit.api.metadata.DefaultMetaDataKeyLevel;
import org.mule.devkit.api.metadata.exception.InvalidKeyException;
import org.mule.devkit.api.ws.definition.ServiceDefinition;
import org.mule.devkit.internal.metadata.InternalComposedMetaDataKeyBuilder;
import org.mule.devkit.internal.ws.common.EnhancedServiceDefinition;
import org.mule.devkit.internal.ws.common.WsdlAdapter;
import org.mule.devkit.internal.ws.common.WsdlUtils;
import org.mule.devkit.internal.ws.metadata.WsdlSchemaUtils;
import org.mule.devkit.internal.ws.model.WsdlIntrospecterUtils;

public class WsdlMetaDataDescriptor {
    public static final String SOAP_PREFIX = "soap.";

    public Result<List<MetaDataKey>> getMetaDataKeys(WsdlAdapter wsdlAdapter) {
        try {
            ArrayList<MetaDataKey> gatheredMetaDataKeys = new ArrayList<MetaDataKey>();
            for (ServiceDefinition serviceDefinition : wsdlAdapter.serviceDefinitions()) {
                gatheredMetaDataKeys.addAll(this.getKeysFor(wsdlAdapter, serviceDefinition));
            }
            return new DefaultResult(gatheredMetaDataKeys, Result.Status.SUCCESS);
        }
        catch (Exception e) {
            return new DefaultResult(null, Result.Status.FAILURE, "There was an error retrieving the metadata keys from service provider after acquiring connection, for more detailed information please read the provided stacktrace", (FailureType)MetaDataFailureType.ERROR_METADATA_KEYS_RETRIEVER, (Throwable)e);
        }
    }

    public Result<MetaData> getMetaData(MetaDataKey metaDataKey, WsdlAdapter wsdlAdapter) {
        try {
            StructureIdentifierMetaDataModelProperty metaDataModelProperty;
            MetaData metaData;
            EnhancedServiceDefinition enhancedServiceDefinition = this.resolveEnhancedServiceDefinition(metaDataKey, wsdlAdapter);
            if (this.isInputMetaData(metaDataKey)) {
                metaData = this.loadInputMetadata(enhancedServiceDefinition);
                metaDataModelProperty = new StructureIdentifierMetaDataModelProperty(metaDataKey, false);
            } else {
                metaData = this.loadOutputMetadata(enhancedServiceDefinition);
                metaDataModelProperty = new StructureIdentifierMetaDataModelProperty(metaDataKey, true);
            }
            metaData.getPayload().addProperty((MetaDataModelProperty)metaDataModelProperty);
            return new DefaultResult((Object)metaData);
        }
        catch (Exception e) {
            return new DefaultResult(null, Result.Status.FAILURE, this.getMetaDataException(metaDataKey), (FailureType)MetaDataFailureType.ERROR_METADATA_RETRIEVER, (Throwable)e);
        }
    }

    private boolean isInputMetaData(MetaDataKey metaDataKey) {
        return TypeDescribingProperty.TypeScope.INPUT.equals((Object)((TypeDescribingProperty)metaDataKey.getProperty(TypeDescribingProperty.class)).getTypeScope());
    }

    private String getMetaDataException(MetaDataKey key) {
        if (!StringUtils.isBlank((String)key.getId())) {
            return "There was an error retrieving metadata from key: " + key.getId() + " after acquiring the connection, for more detailed information please read the provided stacktrace";
        }
        return "There was an error retrieving metadata after acquiring the connection, MetaDataKey is null or its id is null, for more detailed information please read the provided stacktrace";
    }

    private List<MetaDataKey> getKeysFor(WsdlAdapter wsdlAdapter, ServiceDefinition serviceDefinition) {
        String keySeparator = wsdlAdapter.wsdlSeparator();
        Definition definition = WsdlUtils.parseWSDL(serviceDefinition.getWsdlUrl().toString());
        Service service = WsdlIntrospecterUtils.resolveService(serviceDefinition, definition);
        Port port = WsdlIntrospecterUtils.resolvePort(serviceDefinition, service, definition);
        DefaultMetaDataKeyLevel operations = new DefaultMetaDataKeyLevel();
        for (String operation : WsdlUtils.getOperationNames(port)) {
            operations.addId(operation, operation);
        }
        InternalComposedMetaDataKeyBuilder builder = InternalComposedMetaDataKeyBuilder.newKeyCombination().withSeparator(keySeparator);
        if (!wsdlAdapter.singleServiceDefinitionId().isPresent()) {
            builder.newLevel().addId(serviceDefinition.getId(), serviceDefinition.getDisplayName()).endLevel();
        }
        return InternalComposedMetaDataKeyBuilder.toSimpleKey(builder.addMultiValueLevel(operations).build(), keySeparator);
    }

    private EnhancedServiceDefinition resolveEnhancedServiceDefinition(MetaDataKey key, WsdlAdapter wsdlAdapter) throws Exception {
        String operation;
        String id;
        if (StringUtils.isBlank((String)key.getId())) {
            throw new InvalidKeyException("Key is empty");
        }
        if (wsdlAdapter.singleServiceDefinitionId().isPresent()) {
            id = (String)wsdlAdapter.singleServiceDefinitionId().get();
            operation = key.getId();
        } else {
            if (!StringUtils.contains((String)key.getId(), (String)wsdlAdapter.wsdlSeparator())) {
                throw new InvalidKeyException(String.format("Key %s does not contains the expected service-operation separator %s", key.getId(), wsdlAdapter.wsdlSeparator()));
            }
            if (StringUtils.countMatches((String)key.getId(), (String)wsdlAdapter.wsdlSeparator()) != 1) {
                throw new InvalidKeyException(String.format("Key %s contains too many service-operation separators %s, only one keySeparator occurrence is expected.", key.getId(), wsdlAdapter.wsdlSeparator()));
            }
            String escapedSeparator = Pattern.quote(wsdlAdapter.wsdlSeparator());
            String[] splitKey = key.getId().split(escapedSeparator);
            if (splitKey.length != 2) {
                throw new InvalidKeyException(String.format("Key %s is not valid, two non-empty parts must be separated with %s", key.getId(), wsdlAdapter.wsdlSeparator()));
            }
            id = splitKey[0];
            operation = splitKey[1];
        }
        if (StringUtils.isBlank((String)id) || StringUtils.isBlank((String)operation)) {
            throw new InvalidKeyException(String.format("Key %s is not valid, two non-empty parts must be present", key.getId()));
        }
        return wsdlAdapter.wsResolver().enhancedServiceDefinition(id, wsdlAdapter, operation);
    }

    private MetaData loadInputMetadata(EnhancedServiceDefinition enhancedServiceDefinition) throws Exception {
        Definition definition = WsdlUtils.parseWSDL(enhancedServiceDefinition.getWsdlUrl().toString());
        List<String> schemas = WsdlSchemaUtils.getSchemas(definition);
        Message message = WsdlUtils.getInputMessage(definition, enhancedServiceDefinition.getService(), enhancedServiceDefinition.getPort(), enhancedServiceDefinition.getOperation());
        if (message == null) {
            return null;
        }
        Part part = this.getMessagePart(message);
        if (part != null) {
            MetaData inputMetadata = this.createMetaData(schemas, part, enhancedServiceDefinition.getWsdlUrl());
            this.addInputProperties(inputMetadata, enhancedServiceDefinition.getService(), enhancedServiceDefinition.getPort(), enhancedServiceDefinition.getOperation(), definition, schemas);
            return inputMetadata;
        }
        return null;
    }

    private MetaData loadOutputMetadata(EnhancedServiceDefinition enhancedServiceDefinition) throws Exception {
        Definition definition = WsdlUtils.parseWSDL(enhancedServiceDefinition.getWsdlUrl().toString());
        List<String> schemas = WsdlSchemaUtils.getSchemas(definition);
        Message message = WsdlUtils.getOutputMessage(definition, enhancedServiceDefinition.getService(), enhancedServiceDefinition.getPort(), enhancedServiceDefinition.getOperation());
        if (message == null) {
            return null;
        }
        Part part = this.getMessagePart(message);
        if (part != null) {
            MetaData outputMetadata = this.createMetaData(schemas, part, enhancedServiceDefinition.getWsdlUrl());
            this.addOutputProperties(outputMetadata, enhancedServiceDefinition.getService(), enhancedServiceDefinition.getPort(), enhancedServiceDefinition.getOperation(), definition, schemas);
            return outputMetadata;
        }
        return null;
    }

    private Part getMessagePart(Message message) {
        if (message == null) {
            return null;
        }
        Map parts = message.getParts();
        if (!parts.isEmpty()) {
            if (parts.size() > 1) {
                throw new RuntimeException("Warning: Operation Messages With More Than 1 Part Are Not Supported.");
            }
            Object firstValueKey = parts.keySet().toArray()[0];
            return (Part)parts.get(firstValueKey);
        }
        return null;
    }

    private MetaData createMetaData(List<String> schemas, Part part, URL url) {
        if (part != null) {
            if (part.getElementName() != null) {
                QName elementName = part.getElementName();
                XmlMetaDataBuilder createXmlObject = new DefaultMetaDataBuilder().createXmlObject(elementName);
                for (String schema : schemas) {
                    createXmlObject.addSchemaStringList(new String[]{schema});
                }
                createXmlObject.setEncoding(this.charset());
                createXmlObject.setSourceUri(url);
                return new DefaultMetaData(createXmlObject.build());
            }
            if (part.getTypeName() != null) {
                DataType dataType = this.getDataTypeFromTypeName(part);
                DefaultSimpleMetaDataModel defaultSimpleMetaDataModel = new DefaultSimpleMetaDataModel(dataType);
                return new DefaultMetaData((MetaDataModel)defaultSimpleMetaDataModel);
            }
        }
        return new DefaultMetaData((MetaDataModel)new DefaultUnknownMetaDataModel());
    }

    private void addInputProperties(MetaData inputMetadata, String wsdlService, String wsdlPort, String wsdlOperation, Definition def, List<String> schemas) {
        List<SOAPHeader> inputHeaders = WsdlUtils.getInputHeaders(def, wsdlService, wsdlPort, wsdlOperation);
        for (SOAPHeader soapHeader : inputHeaders) {
            Message message = def.getMessage(soapHeader.getMessage());
            if (message == null) continue;
            Part part = message.getPart(soapHeader.getPart());
            inputMetadata.addProperty(MetaDataPropertyScope.OUTBOUND, SOAP_PREFIX + soapHeader.getPart(), (MetaDataModel)new DefaultXmlMetaDataModel(schemas, part.getElementName(), this.charset(), new MetaDataModelProperty[0]), new MetaDataFieldProperty[0]);
        }
    }

    private void addOutputProperties(MetaData inputMetadata, String wsdlService, String wsdlPort, String wsdlOperation, Definition def, List<String> schemas) {
        List<SOAPHeader> outputHeaders = WsdlUtils.getOutputHeaders(def, wsdlService, wsdlPort, wsdlOperation);
        for (SOAPHeader soapHeader : outputHeaders) {
            Message message = def.getMessage(soapHeader.getMessage());
            if (message == null) continue;
            Part part = message.getPart(soapHeader.getPart());
            inputMetadata.addProperty(MetaDataPropertyScope.INBOUND, SOAP_PREFIX + soapHeader.getPart(), (MetaDataModel)new DefaultXmlMetaDataModel(schemas, part.getElementName(), this.charset(), new MetaDataModelProperty[0]), new MetaDataFieldProperty[0]);
        }
    }

    private Charset charset() {
        return Charset.defaultCharset();
    }

    private DataType getDataTypeFromTypeName(Part part) {
        String localPart = part.getTypeName().getLocalPart();
        HashMap<String, DataType> types = new HashMap<String, DataType>();
        types.put("string", DataType.STRING);
        types.put("boolean", DataType.BOOLEAN);
        types.put("date", DataType.DATE);
        types.put("decimal", DataType.DECIMAL);
        types.put("byte", DataType.BYTE);
        types.put("unsignedByte", DataType.BYTE);
        types.put("dateTime", DataType.DATE_TIME);
        types.put("int", DataType.INTEGER);
        types.put("integer", DataType.INTEGER);
        types.put("unsignedInt", DataType.INTEGER);
        types.put("short", DataType.INTEGER);
        types.put("unsignedShort", DataType.INTEGER);
        types.put("long", DataType.LONG);
        types.put("unsignedLong", DataType.LONG);
        types.put("double", DataType.DOUBLE);
        DataType dataType = (DataType)types.get(localPart);
        return dataType != null ? dataType : DataType.STRING;
    }
}

