/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.internal.ws.common;

import com.ibm.wsdl.extensions.schema.SchemaSerializer;
import com.ibm.wsdl.extensions.soap12.SOAP12BindingImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;

public class WsdlUtils {
    public static String[] getServiceNames(Definition wsdlDefinition) {
        Map services;
        ArrayList<String> serviceNames = new ArrayList<String>();
        if (wsdlDefinition != null && (services = wsdlDefinition.getServices()) != null) {
            for (QName name : services.keySet()) {
                serviceNames.add(name.getLocalPart());
            }
        }
        return serviceNames.toArray(new String[serviceNames.size()]);
    }

    public static String[] getPortNames(Service service) {
        ArrayList names = new ArrayList();
        if (service != null && service.getPorts() != null) {
            names.addAll(service.getPorts().keySet());
        }
        return names.toArray(new String[names.size()]);
    }

    public static String getPortSOAPAddress(Port port) {
        if (WsdlUtils.isAnyNull(port)) {
            return null;
        }
        List extensibilityElements = port.getExtensibilityElements();
        for (Object address : extensibilityElements) {
            if (address instanceof SOAPAddress) {
                return ((SOAPAddress)address).getLocationURI();
            }
            if (address instanceof SOAP12Address) {
                return ((SOAP12Address)address).getLocationURI();
            }
            if (!(address instanceof HTTPAddress)) continue;
            return ((HTTPAddress)address).getLocationURI();
        }
        return null;
    }

    public static String[] getOperationNames(Port port) {
        if (WsdlUtils.isAnyNull(port)) {
            return null;
        }
        ArrayList<String> operationNames = new ArrayList<String>();
        List bindingOperations = port.getBinding().getBindingOperations();
        for (BindingOperation operation : bindingOperations) {
            operationNames.add(operation.getName());
        }
        return operationNames.toArray(new String[operationNames.size()]);
    }

    public static Service getService(String wsdlPath, String wsdlService) {
        Definition def;
        if (WsdlUtils.isAnyNull(wsdlPath, wsdlService)) {
            return null;
        }
        if (StringUtils.isNotBlank((String)wsdlPath) && StringUtils.isNotBlank((String)wsdlService) && (def = WsdlUtils.parseWSDL(wsdlPath)) != null) {
            return WsdlUtils.getService(def, wsdlService);
        }
        return null;
    }

    public static Port getPort(String wsdlLocation, String selectedService, String selectedPort) {
        if (WsdlUtils.isAnyNull(wsdlLocation, selectedService, selectedPort)) {
            return null;
        }
        Service service = WsdlUtils.getService(wsdlLocation.trim(), selectedService);
        if (service != null && StringUtils.isNotBlank((String)selectedPort)) {
            return service.getPort(selectedPort.trim());
        }
        return null;
    }

    public static Port getPort(Service service, String portId) {
        if (WsdlUtils.isAnyNull(service, portId)) {
            return null;
        }
        if (StringUtils.isNotBlank((String)portId)) {
            return service.getPort(portId.trim());
        }
        return null;
    }

    public static Operation getOperation(Definition def, String wsdlService, String wsdlPort, String wsdlOperation) {
        Port port;
        if (WsdlUtils.isAnyNull(def, wsdlService, wsdlPort, wsdlOperation)) {
            return null;
        }
        Service service = WsdlUtils.getService(def, wsdlService);
        if (service != null && (port = service.getPort(wsdlPort)) != null) {
            return WsdlUtils.getOperation(port, wsdlOperation);
        }
        return null;
    }

    public static Operation getOperation(Port port, String wsdlOperation) {
        if (WsdlUtils.isAnyNull(wsdlOperation, port)) {
            return null;
        }
        PortType portType = port.getBinding().getPortType();
        Operation operation = portType.getOperation(wsdlOperation, null, null);
        return operation;
    }

    public static Service getService(Definition def, String wsdlService) {
        if (WsdlUtils.isAnyNull(def, wsdlService)) {
            return null;
        }
        if (def != null) {
            return def.getService(new QName(def.getTargetNamespace(), wsdlService));
        }
        return null;
    }

    public static Message getOutputMessage(Definition def, String wsdlService, String wsdlPort, String wsdlOperation) {
        if (WsdlUtils.isAnyNull(def, wsdlService, wsdlPort, wsdlOperation)) {
            return null;
        }
        Operation operation = WsdlUtils.getOperation(def, wsdlService, wsdlPort, wsdlOperation);
        if (operation != null) {
            return WsdlUtils.getOutputMessage(operation);
        }
        return null;
    }

    public static Message getOutputMessage(Operation operation) {
        if (WsdlUtils.isAnyNull(operation)) {
            return null;
        }
        Output output = operation.getOutput();
        if (output != null) {
            return output.getMessage();
        }
        return null;
    }

    public static Message getInputMessage(Definition def, String wsdlService, String wsdlPort, String wsdlOperation) {
        if (WsdlUtils.isAnyNull(def, wsdlService, wsdlPort, wsdlOperation)) {
            return null;
        }
        Operation operation = WsdlUtils.getOperation(def, wsdlService, wsdlPort, wsdlOperation);
        if (operation != null) {
            return WsdlUtils.getInputMessage(operation);
        }
        return null;
    }

    public static Message getInputMessage(Operation operation) {
        if (WsdlUtils.isAnyNull(operation)) {
            return null;
        }
        Input input = operation.getInput();
        if (input != null) {
            return input.getMessage();
        }
        return null;
    }

    public static List<SOAPHeader> getInputHeaders(Definition def, String wsdlService, String wsdlPort, String wsdlOperation) {
        List extensibilityElements;
        BindingInput bindingInput;
        if (WsdlUtils.isAnyNull(def, wsdlService, wsdlPort, wsdlOperation)) {
            return null;
        }
        ArrayList<SOAPHeader> result = new ArrayList<SOAPHeader>();
        BindingOperation bindingOperation = WsdlUtils.getBindingOperation(def, wsdlService, wsdlPort, wsdlOperation);
        if (bindingOperation != null && (bindingInput = bindingOperation.getBindingInput()) != null && (extensibilityElements = bindingInput.getExtensibilityElements()) != null) {
            for (Object element : extensibilityElements) {
                if (element == null || !(element instanceof SOAPHeader)) continue;
                result.add((SOAPHeader)element);
            }
        }
        return result;
    }

    public static List<SOAPHeader> getOutputHeaders(Definition def, String wsdlService, String wsdlPort, String wsdlOperation) {
        List extensibilityElements;
        BindingOutput bindingOutput;
        if (WsdlUtils.isAnyNull(def, wsdlService, wsdlPort, wsdlOperation)) {
            return null;
        }
        ArrayList<SOAPHeader> result = new ArrayList<SOAPHeader>();
        BindingOperation bindingOperation = WsdlUtils.getBindingOperation(def, wsdlService, wsdlPort, wsdlOperation);
        if (bindingOperation != null && (bindingOutput = bindingOperation.getBindingOutput()) != null && (extensibilityElements = bindingOutput.getExtensibilityElements()) != null) {
            for (Object element : extensibilityElements) {
                if (element == null || !(element instanceof SOAPHeader)) continue;
                result.add((SOAPHeader)element);
            }
        }
        return result;
    }

    protected static BindingOperation getBindingOperation(Definition def, String wsdlService, String wsdlPort, String wsdlOperation) {
        Binding binding;
        Operation soapOperation;
        Port port;
        if (WsdlUtils.isAnyNull(def, wsdlService, wsdlPort, wsdlOperation)) {
            return null;
        }
        Service service = WsdlUtils.getService(def, wsdlService);
        if (service != null && (port = service.getPort(wsdlPort)) != null && (soapOperation = WsdlUtils.getOperation(def, wsdlService, wsdlPort, wsdlOperation)) != null && (binding = port.getBinding()) != null) {
            return binding.getBindingOperation(soapOperation.getName(), null, null);
        }
        return null;
    }

    public static boolean hasSoapBody(Binding binding) {
        if (WsdlUtils.isAnyNull(binding)) {
            return false;
        }
        List extensibilityElements = binding.getExtensibilityElements();
        for (Object object : extensibilityElements) {
            if (!(object instanceof SOAPBody) && !(object instanceof SOAPBinding) && !(object instanceof SOAP12BindingImpl)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAnyNull(Object ... parameters) {
        for (Object parameter : parameters) {
            if (parameter != null) continue;
            return true;
        }
        return false;
    }

    public static Definition parseWSDL(String wsdlLocation) {
        try {
            WSDLFactory factory = WSDLFactory.newInstance();
            ExtensionRegistry registry = factory.newPopulatedExtensionRegistry();
            registry.registerSerializer(Types.class, new QName("http://www.w3.org/2001/XMLSchema", "schema"), (ExtensionSerializer)new SchemaSerializer());
            QName header = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "header");
            registry.registerDeserializer(MIMEPart.class, header, registry.queryDeserializer(BindingInput.class, header));
            registry.registerSerializer(MIMEPart.class, header, registry.querySerializer(BindingInput.class, header));
            Class<?> clazz = registry.createExtension(BindingInput.class, header).getClass();
            registry.mapExtensionTypes(MIMEPart.class, header, clazz);
            WSDLReader wsdlReader = factory.newWSDLReader();
            wsdlReader.setFeature("javax.wsdl.verbose", false);
            wsdlReader.setFeature("javax.wsdl.importDocuments", true);
            wsdlReader.setExtensionRegistry(registry);
            Definition definition = wsdlReader.readWSDL(wsdlLocation);
            return definition;
        }
        catch (WSDLException e) {
            throw new RuntimeException("Something went wrong... ", e);
        }
    }
}

