/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio.editor;

import javax.xml.bind.JAXBElement;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.studio.editor.BaseStudioXmlBuilder;
import org.mule.devkit.generation.studio.editor.MimeType;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.studio.AttributeCategory;
import org.mule.devkit.model.studio.AttributeType;
import org.mule.devkit.model.studio.Booleantype;
import org.mule.devkit.model.studio.EncodingType;
import org.mule.devkit.model.studio.EnumElement;
import org.mule.devkit.model.studio.EnumType;
import org.mule.devkit.model.studio.Group;
import org.mule.devkit.model.studio.PatternType;
import org.mule.devkit.model.studio.StringAttributeType;

public class AbstractTransformerBuilder
extends BaseStudioXmlBuilder {
    public static final String ABSTRACT_TRANSFORMER_LOCAL_ID = "abstractTransformer";
    public static final String ABSTRACT_TRANSFORMER_ATTRIBUTE_CATEGORY_CAPTION = "Advanced";
    public static final String ABSTRACT_TRANSFORMER_ATTRIBUTE_CATEGORY_DESCRIPTION = "Advanced settings for transformer";

    public AbstractTransformerBuilder(Context context, Module module) {
        super(context, module);
    }

    public JAXBElement<PatternType> build() {
        return this.objectFactory.createNamespaceTypeTransformer(this.createAbstractTransformer());
    }

    private PatternType createAbstractTransformer() {
        PatternType abstractTransformer = new PatternType();
        abstractTransformer.setLocalId(ABSTRACT_TRANSFORMER_LOCAL_ID);
        abstractTransformer.setCaption(this.helper.formatCaption("Base transformer"));
        abstractTransformer.setDescription(this.helper.formatDescription("Base transformer"));
        abstractTransformer.setAbstract(Boolean.valueOf(true));
        abstractTransformer.setExtends("http://www.mulesoft.org/schema/mule/" + this.module.getModuleName() + "/" + this.module.getModuleName() + "-transformer");
        AttributeCategory attributeCategory = new AttributeCategory();
        attributeCategory.setCaption(this.helper.formatCaption(ABSTRACT_TRANSFORMER_ATTRIBUTE_CATEGORY_CAPTION));
        attributeCategory.setDescription(this.helper.formatDescription(ABSTRACT_TRANSFORMER_ATTRIBUTE_CATEGORY_DESCRIPTION));
        attributeCategory.getGroup().add(this.createTransformerSettingsGroup());
        attributeCategory.getGroup().add(this.createMimeAttributesGroup());
        abstractTransformer.getAttributeCategoryOrRequiredSetAlternativesOrFixedAttribute().add(attributeCategory);
        return abstractTransformer;
    }

    private Group createMimeAttributesGroup() {
        Group mimeAttributesGroup = new Group();
        mimeAttributesGroup.setCaption(this.helper.formatCaption("Mime type attributes"));
        mimeAttributesGroup.setId("mimeTypeAttributes");
        EnumType mimeTypesEnum = new EnumType();
        mimeTypesEnum.setCaption(this.helper.formatCaption("Mime type"));
        mimeTypesEnum.setDescription(this.helper.formatDescription("The mime type of the transformer's output"));
        mimeTypesEnum.setName("mimeType");
        mimeTypesEnum.setXsdType("string");
        mimeTypesEnum.setAllowsCustom(Boolean.valueOf(true));
        for (MimeType mimeType : MimeType.values()) {
            EnumElement mimeTypeOption = new EnumElement();
            mimeTypeOption.setValue(mimeType.toString());
            mimeTypesEnum.getOption().add(mimeTypeOption);
        }
        mimeAttributesGroup.getRegexpOrEncodingOrModeSwitch().add(this.helper.createJAXBElement((AttributeType)mimeTypesEnum));
        return mimeAttributesGroup;
    }

    private Group createTransformerSettingsGroup() {
        Group transformerSettingsGroup = new Group();
        transformerSettingsGroup.setCaption(this.helper.formatCaption("Transformer Settings"));
        transformerSettingsGroup.setId("abstractTransformerSettings");
        StringAttributeType returnClassAttribute = new StringAttributeType();
        returnClassAttribute.setName("returnClass");
        returnClassAttribute.setDescription(this.helper.formatDescription("The class of the message generated by the transformer. This is used if transformers are auto-selected and to validate that the transformer returns the correct type. Note that if you need to specify an array type you need postfix the class name with '[]'. For example, if you want return a an Orange[], you set the return class to 'org.mule.tck.testmodels.fruit.Orange[]'."));
        returnClassAttribute.setCaption(this.helper.formatCaption("Return Class"));
        Booleantype ignoreBadInputAttribute = new Booleantype();
        ignoreBadInputAttribute.setName("ignoreBadInput");
        ignoreBadInputAttribute.setDescription(this.helper.formatDescription("Many transformers only accept certain classes. Such transformers are never called with inappropriate input (whatever the value of this attribute). If a transformer forms part of a chain and cannot accept the current message class, this flag controls whether the remaining part of the chain is evaluated. If true, the next transformer is called. If false the chain ends, keeping the result generated up to that point."));
        ignoreBadInputAttribute.setCaption(this.helper.formatCaption("Ignore Bad Input"));
        ignoreBadInputAttribute.setXsdType("substitutableBoolean");
        EncodingType encodingAttribute = new EncodingType();
        encodingAttribute.setName("encoding");
        encodingAttribute.setDescription(this.helper.formatDescription("String encoding used for transformer output."));
        encodingAttribute.setCaption(this.helper.formatCaption("Encoding"));
        encodingAttribute.setXsdType("string");
        transformerSettingsGroup.getRegexpOrEncodingOrModeSwitch().add(this.helper.createJAXBElement((AttributeType)returnClassAttribute));
        transformerSettingsGroup.getRegexpOrEncodingOrModeSwitch().add(this.helper.createJAXBElement((AttributeType)ignoreBadInputAttribute));
        transformerSettingsGroup.getRegexpOrEncodingOrModeSwitch().add(this.helper.createJAXBElement((AttributeType)encodingAttribute));
        return transformerSettingsGroup;
    }
}

