/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.generation.studio.editor.ws;

import org.mule.api.annotations.param.MetaDataKeyParamAffectsType;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.studio.editor.MuleStudioEditorXmlGenerator;
import org.mule.devkit.generation.studio.editor.PatternTypeBuilder;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.studio.AttributeCategory;
import org.mule.devkit.model.studio.Group;
import org.mule.devkit.model.studio.PatternType;
import org.mule.devkit.model.studio.metadata.MultiTypeChooserType;
import org.mule.util.StringUtils;

public class InvokeWsdlPatternTypeBuilder extends PatternTypeBuilder {

    public InvokeWsdlPatternTypeBuilder(Context context, Module module) {
        super(context, null, module);
    }

    @Override
    public PatternType build() {
        return this.fillPatternType();
    }

    private PatternType fillPatternType() {
        String invokeMethodName = "invoke";

        PatternType patternType = new PatternType();

        patternType.setLocalId(invokeMethodName);
        patternType.setCaption(helper.formatCaption(invokeMethodName));
        patternType.setAbstract(true);
        patternType.setExtends(MuleStudioEditorXmlGenerator.URI_PREFIX + module.getModuleName() + '/' + helper.getGlobalRefId(module.getModuleName()));
        patternType.setIcon(getIcon());
        patternType.setImage(getImage());

        patternType.setMetaData("dynamic");

        AttributeCategory attributeCategoryGeneral = new AttributeCategory();
        attributeCategoryGeneral.setCaption(helper.formatCaption(MuleStudioEditorXmlGenerator.ATTRIBUTE_CATEGORY_DEFAULT_CAPTION));
        attributeCategoryGeneral.setDescription(helper.formatDescription(MuleStudioEditorXmlGenerator.ATTRIBUTE_CATEGORY_DEFAULT_DESCRIPTION));

        Group generalGroup = new Group();
        generalGroup.setCaption(helper.formatCaption(GENERAL_GROUP_NAME));
        generalGroup.setId(StringUtils.uncapitalize(GENERAL_GROUP_NAME));
        attributeCategoryGeneral.getGroup().add(generalGroup);


        MultiTypeChooserType attributeType = new MultiTypeChooserType();
        attributeType.setCaptions(this.module.manager().wsdlProviderComponent().get(0).plainedKeyLabels());
        attributeType.setKeySeparator(this.module.manager().wsdlProviderComponent().get(0).keySeparator());

        attributeType.setSupportsExpressions(true);
        attributeType.setAssociatedConfig("config-ref");
        attributeType.setAffects(MetaDataKeyParamAffectsType.BOTH.name());

        String parameterName = "type";
        attributeType.setCaption("Type");
        attributeType.setDescription(helper.formatDescription("The representation of the WSDL file plus an operation."));
        attributeType.setName(parameterName);

        attributeType.setRequired(true);
        attributeType.setJavaType(String.class.getCanonicalName());

        generalGroup.getRegexpOrEncodingOrModeSwitch().add(helper.createJAXBElement(attributeType));
        patternType.getAttributeCategoryOrRequiredSetAlternativesOrFixedAttribute().add(attributeCategoryGeneral);

        return patternType;
    }

    @Override
    protected String getImage() {
        return helper.getConnectorImage(module);
    }

    @Override
    protected String getIcon() {
        return helper.getConnectorIcon(module);
    }
}
