/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.generation.studio.editor;

import org.mule.devkit.model.Field;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.Variable;

import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import java.util.HashSet;
import java.util.Set;

public class ComplexTypeParameterVisitor extends AbstractVisitor {

    private Set<Variable> registeredComplexTypes;

    public ComplexTypeParameterVisitor() {
        this.registeredComplexTypes = new HashSet<Variable>();
    }

    @Override
    public void visit(Parameter parameter) {
        super.visit(parameter);

        checkIfComplexType(parameter);
    }

    @Override
    public void visit(Field field) {
        super.visit(field);

        checkIfComplexType(field);
    }

    private void checkIfComplexType(Variable identifiable) {
        Type type = identifiable.asType();

        if (type != null && (type.isComplexType() || identifiable.isArrayOrListOfComplexType(false)) && !identifiable.isRefOnly() && !registeredComplexTypes.contains(identifiable)) {
            registeredComplexTypes.add(identifiable);
        }
    }

    public Set<Variable> getRegisteredComplexTypes() {
        return registeredComplexTypes;
    }

}
