/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio.editor.globalcloudconnector;

import com.google.common.base.Optional;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import org.mule.api.annotations.ConnectStrategy;
import org.mule.api.annotations.TestConnectivity;
import org.mule.api.annotations.display.UserDefinedMetaData;
import org.mule.api.callback.HttpCallback;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.studio.editor.GlobalTypeBuilder;
import org.mule.devkit.generation.studio.utils.JaxbUnmarshaller;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.connectivity.ConnectMethod;
import org.mule.devkit.model.studio.AttributeCategory;
import org.mule.devkit.model.studio.AttributeType;
import org.mule.devkit.model.studio.EnumElement;
import org.mule.devkit.model.studio.EnumType;
import org.mule.devkit.model.studio.GlobalType;
import org.mule.devkit.model.studio.Group;
import org.mule.devkit.model.studio.MetaDataType;
import org.mule.devkit.model.studio.NamespaceType;
import org.mule.devkit.model.studio.NestedElementReference;
import org.mule.devkit.model.studio.libraries.RequiredLibraries;
import org.mule.util.StringUtils;

public abstract class GlobalCloudConnectorTypeBuilder
extends GlobalTypeBuilder {
    public static final String REQUIRED_LIBS_DIR = "src/main/resources/META-INF";
    public static final String REQUIRED_LIBS_SUFFIX = "-required-libs.xml";
    public static final String STUDIO_FULL_QUALIFIED_PACKAGE_VALUE_PERSISTANT = "org.mule.tooling.ui.modules.core.widgets.meta.";
    public static final String STUDIO_POOLING_PROFILE_PERSISTANT_VALUE = "org.mule.tooling.ui.modules.core.widgets.meta.PoolingProfileValuePersistence";
    public static final String STUDIO_CACHE_CONFIGURATION_PERSISTANT_VALUE = "org.mule.tooling.ui.modules.core.widgets.meta.CacheConfigurationValuePersistence";
    public static final String STUDIO_HTTP_TRANSACTION_PERSISTANT_VALUE = "org.mule.tooling.ui.modules.core.widgets.meta.HTTPTransactionValuePersistence";
    private boolean abstrac7;
    private String globalRefId;

    public GlobalCloudConnectorTypeBuilder(Context context, Module module, boolean abstrac7, String globalRefId) {
        super(context, module);
        this.abstrac7 = abstrac7;
        this.globalRefId = globalRefId == null ? this.helper.getGlobalRefId(module.getModuleName()) : globalRefId;
    }

    @Override
    public GlobalType build() {
        GlobalType globalCloudConnector = super.build();
        this.buildConnectivityTestingAttr(globalCloudConnector);
        this.buildMetaDataAttr(globalCloudConnector, this.module.hasDynamicMetadata());
        this.buildRequiredLibsAttr(globalCloudConnector);
        this.buildSupportUserDefinedMetaData(globalCloudConnector, this.module);
        globalCloudConnector.setVersions(this.buildVersionsString());
        return globalCloudConnector;
    }

    protected void buildSupportUserDefinedMetaData(GlobalType globalCloudConnector, Module module) {
        globalCloudConnector.setSupportsUserDefinedMetaData(this.hasProcessorsWithTransformingValue(module));
    }

    private boolean hasProcessorsWithTransformingValue(Module module) {
        for (ProcessorMethod processorMethod : module.getProcessorMethods()) {
            if (!processorMethod.hasAnnotation(UserDefinedMetaData.class)) continue;
            return true;
        }
        return false;
    }

    private void buildRequiredLibsAttr(GlobalType globalCloudConnector) {
        String fileName = this.moduleName + "-" + globalCloudConnector.getLocalId() + REQUIRED_LIBS_SUFFIX;
        File rootLibrariesDir = new File(this.context.getMavenInformation().getBuildDirectory(), REQUIRED_LIBS_DIR);
        File requiredLibrariesXml = new File(rootLibrariesDir, fileName);
        if (requiredLibrariesXml.exists()) {
            this.loadRequiredLibraries(globalCloudConnector, requiredLibrariesXml);
        }
    }

    private void loadRequiredLibraries(GlobalType globalCloudConnector, File libXml) {
        RequiredLibraries libs;
        JAXBElement root = (JAXBElement)JaxbUnmarshaller.unmarshallXml(libXml.getPath(), NamespaceType.class);
        if (((NamespaceType)root.getValue()).getRequiredLibs() != null && (libs = (RequiredLibraries)((NamespaceType)root.getValue()).getRequiredLibs().getValue()) != null && libs.hasElements()) {
            globalCloudConnector.setRequiredLibs(libs);
        }
    }

    protected abstract void buildConnectivityTestingAttr(GlobalType var1);

    protected void buildMetaDataAttr(GlobalType globalCloudConnector, boolean dynamicMetadata) {
        String metaDataSwitch = dynamicMetadata ? "dynamic" : "static";
        globalCloudConnector.setMetaData(metaDataSwitch);
        globalCloudConnector.setMetaDataKeyDisplay("DISPLAY_NAME");
    }

    protected void setConnectivityTestingAttribute(GlobalType globalCloudConnector, Optional<Method> methodOptional) {
        boolean active = false;
        String label = null;
        if (methodOptional.isPresent()) {
            TestConnectivity testConnectivity = (TestConnectivity)((Method)methodOptional.get()).getAnnotation(TestConnectivity.class);
            active = testConnectivity.active();
            label = testConnectivity.label();
        }
        this.setConnectivityTestingAttribute(globalCloudConnector, active, label);
    }

    private void setConnectivityTestingAttribute(GlobalType globalCloudConnector, boolean hasConnectivityTesting, String label) {
        if (!this.module.getMinMuleVersion().atLeastBase("3.4")) {
            hasConnectivityTesting = false;
        }
        if (hasConnectivityTesting) {
            globalCloudConnector.setConnectivityTesting("on");
            globalCloudConnector.setConnectivityTestingLabel(StringUtils.isBlank((String)label) ? "Test Connection..." : label);
        } else {
            globalCloudConnector.setConnectivityTesting("off");
        }
    }

    @Override
    protected List<AttributeCategory> getAttributeCategories() {
        Group group = new Group();
        group.setId(this.moduleName + "GenericProperties");
        group.getRegexpOrEncodingOrModeSwitch().add(this.objectFactory.createGroupName(this.createNameAttributeType()));
        group.setCaption(this.helper.formatCaption("Basic Settings"));
        return this.processConfigurableFields(group);
    }

    @Override
    protected void createMetaDataAttributes(Map<String, Group> groupsByName, Map<String, AttributeCategory> attributeCategoriesByName) {
        if (this.module.hasDynamicMetadata()) {
            Group defaultGroup = groupsByName.get("General");
            if (defaultGroup == null) {
                defaultGroup = new Group();
                defaultGroup.setCaption(this.helper.formatCaption("General"));
                defaultGroup.setId(StringUtils.uncapitalize((String)"General"));
                groupsByName.put("General", defaultGroup);
                if (attributeCategoriesByName.get("General") == null) {
                    attributeCategoriesByName.put("General", new AttributeCategory());
                    attributeCategoriesByName.get("General").setCaption("General");
                    attributeCategoriesByName.get("General").getGroup().add(defaultGroup);
                } else {
                    attributeCategoriesByName.get("General").getGroup().add(defaultGroup);
                }
            }
            MetaDataType metaDataType = new MetaDataType();
            metaDataType.setName("useMetaData");
            metaDataType.setCaption("useMetaData");
            defaultGroup.getRegexpOrEncodingOrModeSwitch().add(this.helper.createJAXBElement((AttributeType)metaDataType));
        }
    }

    @Override
    protected void processConnectionAttributes(Map<String, Group> groupsByName, Map<String, AttributeCategory> attributeCategoriesByName) {
        List<AttributeType> connAttrbs = this.getConnectionAttributes();
        if (!connAttrbs.isEmpty()) {
            Group connectionAttributesGroup = new Group();
            connectionAttributesGroup.setCaption(this.helper.formatCaption("Connection"));
            connectionAttributesGroup.setId(StringUtils.uncapitalize((String)"Connection"));
            groupsByName.put("Connection", connectionAttributesGroup);
            connectionAttributesGroup.getRegexpOrEncodingOrModeSwitch().addAll(this.helper.createJAXBElements(connAttrbs));
            AttributeCategory defaultAttributeCategory = attributeCategoriesByName.get("General");
            defaultAttributeCategory.getGroup().add(connectionAttributesGroup);
        }
    }

    protected abstract List<AttributeType> getConnectionAttributes();

    @Override
    protected void createPoolingProfileAttributes(Map<String, Group> groupsByName, Map<String, AttributeCategory> attributeCategoriesByName) {
        if (this.hasConnectionMethod() && this.connectMethod().getStrategy().equals((Object)ConnectStrategy.MULTIPLE_INSTANCES)) {
            AttributeCategory poolProfileTab = new AttributeCategory();
            poolProfileTab.setCaption("Pooling Profile");
            poolProfileTab.setDescription("Pooling profile options.");
            Group poolingProfileGroup = new Group();
            poolingProfileGroup.setCaption("Pooling Profile");
            poolingProfileGroup.setId("poolingProfile");
            NestedElementReference childElement = new NestedElementReference();
            childElement.setName("http://www.mulesoft.org/schema/mule/" + this.moduleName + "/" + "connection-pooling-profile");
            childElement.setCaption("");
            childElement.setDescription("");
            childElement.setInplace(Boolean.valueOf(true));
            childElement.setValuePersistence(STUDIO_POOLING_PROFILE_PERSISTANT_VALUE);
            poolingProfileGroup.getRegexpOrEncodingOrModeSwitch().add(this.objectFactory.createGroupChildElement(childElement));
            poolProfileTab.getGroup().add(poolingProfileGroup);
            attributeCategoriesByName.put("Pooling Profile", poolProfileTab);
        }
    }

    @Override
    protected void createCacheConfigAttributes(Map<String, Group> groupsByName, Map<String, AttributeCategory> attributeCategoriesByName) {
        if (this.hasConnectionMethod() && this.connectMethod().getStrategy().equals((Object)ConnectStrategy.SINGLE_INSTANCE)) {
            AttributeCategory cacheConfigTab = new AttributeCategory();
            cacheConfigTab.setCaption("Cache Configuration");
            cacheConfigTab.setDescription("Cache configuration options.");
            Group cacheConfigGroup = new Group();
            cacheConfigGroup.setCaption("Cache Configuration");
            cacheConfigGroup.setId("cacheConfig");
            NestedElementReference childElement = new NestedElementReference();
            childElement.setName("http://www.mulesoft.org/schema/mule/" + this.moduleName + "/" + "cache-config");
            childElement.setCaption("");
            childElement.setDescription("");
            childElement.setInplace(Boolean.valueOf(true));
            childElement.setValuePersistence(STUDIO_CACHE_CONFIGURATION_PERSISTANT_VALUE);
            cacheConfigGroup.getRegexpOrEncodingOrModeSwitch().add(this.objectFactory.createGroupChildElement(childElement));
            cacheConfigTab.getGroup().add(cacheConfigGroup);
            attributeCategoriesByName.put("Cache Config", cacheConfigTab);
        }
    }

    @Override
    protected void createReconnectionAttributes(Map<String, Group> groupsByName, Map<String, AttributeCategory> attributeCategoriesByName) {
        if (this.hasConnectionMethod()) {
            AttributeCategory reconnectionTab = new AttributeCategory();
            reconnectionTab.setCaption("Reconnection");
            reconnectionTab.setDescription("Reconnection options.");
            Group strategiesGroup = new Group();
            strategiesGroup.setCaption("Strategies");
            strategiesGroup.setId("reconnectionStrategies");
            NestedElementReference childElement = new NestedElementReference();
            childElement.setName("http://www.mulesoft.org/schema/mule/core/reconnectionStrategyElement");
            childElement.setValuePersistence(STUDIO_HTTP_TRANSACTION_PERSISTANT_VALUE);
            childElement.setCaption("");
            childElement.setDescription("");
            childElement.setInplace(Boolean.valueOf(true));
            strategiesGroup.getRegexpOrEncodingOrModeSwitch().add(this.objectFactory.createGroupChildElement(childElement));
            childElement = new NestedElementReference();
            childElement.setName("http://www.mulesoft.org/schema/mule/core/abstractReconnectionStrategy");
            childElement.setCaption("");
            childElement.setDescription("");
            childElement.setAllowSubTypes(Boolean.valueOf(true));
            childElement.setVisibleInDialog(Boolean.valueOf(false));
            childElement.setAllowedSubTypes("http://www.mulesoft.org/schema/mule/core/reconnect,http://www.mulesoft.org/schema/mule/core/reconnect-custom-strategy,http://www.mulesoft.org/schema/mule/core/reconnect-forever");
            strategiesGroup.getRegexpOrEncodingOrModeSwitch().add(this.objectFactory.createGroupChildElement(childElement));
            reconnectionTab.getGroup().add(strategiesGroup);
            attributeCategoriesByName.put("Reconnection", reconnectionTab);
        }
    }

    protected void buildOAuthConfig(Map<String, Group> groupsByName, Map<String, AttributeCategory> attributeCategoriesByName) {
        AttributeCategory oauthAttributeCategory = new AttributeCategory();
        oauthAttributeCategory.setCaption(this.helper.formatCaption("OAuth"));
        oauthAttributeCategory.setDescription(this.helper.formatDescription("OAuth."));
        Group oauthCallbackConfigGroup = this.helper.createGroup("oauthCallbackConfigGroup", "OAuth callback config");
        oauthAttributeCategory.getGroup().add(oauthCallbackConfigGroup);
        NestedElementReference oauthCallbackConfigChildElement = new NestedElementReference();
        oauthCallbackConfigChildElement.setName("http://www.mulesoft.org/schema/mule/" + this.moduleName + "/" + "oauth-callback-config");
        oauthCallbackConfigChildElement.setCaption("");
        oauthCallbackConfigChildElement.setDescription("");
        oauthCallbackConfigChildElement.setInplace(Boolean.valueOf(true));
        oauthCallbackConfigGroup.getRegexpOrEncodingOrModeSwitch().add(this.objectFactory.createGroupChildElement(oauthCallbackConfigChildElement));
        Group oauthStoreConfigGroup = this.helper.createGroup("oauthStoreConfigGroup", "OAuth object store config");
        oauthAttributeCategory.getGroup().add(oauthStoreConfigGroup);
        NestedElementReference oauthStoreConfigChildElement = new NestedElementReference();
        oauthStoreConfigChildElement.setName("http://www.mulesoft.org/schema/mule/" + this.moduleName + "/" + "oauth-store-config");
        oauthStoreConfigChildElement.setCaption("");
        oauthStoreConfigChildElement.setDescription("");
        oauthStoreConfigChildElement.setInplace(Boolean.valueOf(true));
        oauthStoreConfigGroup.getRegexpOrEncodingOrModeSwitch().add(this.objectFactory.createGroupChildElement(oauthStoreConfigChildElement));
        attributeCategoriesByName.put("OAuth", oauthAttributeCategory);
        if (this.module.getMinMuleVersion().atLeast("3.5")) {
            Group defaultGroup = groupsByName.get("Connection");
            if (defaultGroup == null) {
                defaultGroup = new Group();
                defaultGroup.setCaption(this.helper.formatCaption("Connection"));
                defaultGroup.setId(StringUtils.uncapitalize((String)"Connection"));
                groupsByName.put("Connection", defaultGroup);
                if (attributeCategoriesByName.get("Connection") == null) {
                    attributeCategoriesByName.put("Connection", new AttributeCategory());
                    attributeCategoriesByName.get("Connection").setCaption("Connection");
                    attributeCategoriesByName.get("Connection").getGroup().add(defaultGroup);
                } else {
                    attributeCategoriesByName.get("Connection").getGroup().add(defaultGroup);
                }
            }
            EnumType onNoTokenEnum = new EnumType();
            onNoTokenEnum.setCaption(this.helper.formatCaption("On No Token"));
            onNoTokenEnum.setDescription(this.helper.formatDescription("Action to take when no token is found"));
            onNoTokenEnum.setName("onNoToken");
            onNoTokenEnum.setXsdType("string");
            onNoTokenEnum.setAllowsCustom(Boolean.valueOf(false));
            onNoTokenEnum.setDefaultValue("EXCEPTION");
            EnumElement el1 = new EnumElement();
            el1.setValue("EXCEPTION");
            onNoTokenEnum.getOption().add(el1);
            EnumElement el2 = new EnumElement();
            el2.setValue("STOP_FLOW");
            onNoTokenEnum.getOption().add(el2);
            defaultGroup.getRegexpOrEncodingOrModeSwitch().add(this.helper.createJAXBElement((AttributeType)onNoTokenEnum));
        }
    }

    @Override
    protected String getExtendsBasedOnType() {
        return "http://www.mulesoft.org/schema/mule/" + this.module.getModuleName() + '/' + this.globalRefId;
    }

    @Override
    protected String getNameDescriptionBasedOnType() {
        return this.helper.formatDescription("Give a name to this configuration so it can be later referenced by config-ref.");
    }

    @Override
    protected String getImage() {
        return this.helper.getConnectorImage(this.module);
    }

    @Override
    protected String getIcon() {
        return this.helper.getConnectorIcon(this.module);
    }

    @Override
    protected Boolean isAbstract() {
        return this.abstrac7;
    }

    @Override
    protected void setMetadataAttributes(Variable<?> variable, AttributeType attributeType) {
        if (this.module.hasDynamicMetadata() && !variable.isOptional() && !variable.hasDefaultValue()) {
            attributeType.setRequiredForDataSense(Boolean.TRUE);
        }
    }

    protected List<AttributeType> getConnectionAttributes(List<Field> configurableFields) {
        ArrayList<AttributeType> parameters = new ArrayList<AttributeType>();
        for (Field configurableField : configurableFields) {
            parameters.add(this.getAttributeType((Variable)configurableField));
        }
        return parameters;
    }

    @Override
    protected AttributeType getAttributeType(Variable variable) {
        AttributeType parameter = super.getAttributeType(variable);
        this.setRequiredConnectionParameter(parameter, variable);
        return parameter;
    }

    protected List<AttributeCategory> processConfigurableFields(Group defaultGroup) {
        Map<String, AttributeCategory> attributeCategoriesByName = this.processVariableElements(this.getConfigurableFieldsSorted());
        ArrayList<AttributeCategory> attributeCategories = new ArrayList<AttributeCategory>(attributeCategoriesByName.values());
        AttributeCategory attributeCategory = attributeCategoriesByName.get("General");
        if (attributeCategory != null) {
            attributeCategory.setDescription(this.helper.formatDescription(this.module.getModuleName() + " configuration properties"));
            List groups = attributeCategory.getGroup();
            if (groups.isEmpty()) {
                groups.add(defaultGroup);
            } else {
                groups.add(0, defaultGroup);
            }
        } else {
            attributeCategory = new AttributeCategory();
            attributeCategory.setCaption(this.helper.getFormattedCaption(this.module));
            attributeCategory.setDescription(this.helper.formatDescription(this.module.getModuleName() + " configuration properties"));
            attributeCategory.getGroup().add(defaultGroup);
            attributeCategories.add(attributeCategory);
        }
        return attributeCategories;
    }

    @Override
    protected void createHttpCallbackConfig(Map<String, Group> groupsByName, Map<String, AttributeCategory> attributeCategoriesByName) {
        if (this.module.hasProcessorMethodWithParameter(HttpCallback.class)) {
            AttributeCategory httpCallbackAttributeCategory = new AttributeCategory();
            httpCallbackAttributeCategory.setCaption(this.helper.formatCaption("Http Callback"));
            httpCallbackAttributeCategory.setDescription(this.helper.formatDescription("Http Callback."));
            Group httpCallbackConfigGroup = this.helper.createGroup("httpCallbackConfigGroup", "Http callback config");
            httpCallbackAttributeCategory.getGroup().add(httpCallbackConfigGroup);
            NestedElementReference httpCallbackConfigChildElement = new NestedElementReference();
            httpCallbackConfigChildElement.setName("http://www.mulesoft.org/schema/mule/" + this.moduleName + "/" + "http-callback-config");
            httpCallbackConfigChildElement.setCaption("");
            httpCallbackConfigChildElement.setDescription("");
            httpCallbackConfigChildElement.setInplace(Boolean.valueOf(true));
            httpCallbackConfigGroup.getRegexpOrEncodingOrModeSwitch().add(this.objectFactory.createGroupChildElement(httpCallbackConfigChildElement));
            attributeCategoriesByName.put("Http Callback", httpCallbackAttributeCategory);
        }
    }

    protected void setRequiredConnectionParameter(AttributeType attributeType, Variable variable) {
        attributeType.setRequired(Boolean.valueOf(!variable.isOptional()));
    }

    protected abstract List<Field> getConfigurableFieldsSorted();

    protected abstract boolean hasConnectionMethod();

    protected abstract ConnectMethod connectMethod();
}

