/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio.editor.globalcloudconnector;

import com.google.common.base.Optional;
import java.util.Collections;
import java.util.List;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.studio.editor.VariableComparator;
import org.mule.devkit.generation.studio.editor.globalcloudconnector.GlobalCloudConnectorTypeBuilder;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.ConnectionManagementComponent;
import org.mule.devkit.model.module.connectivity.ConnectMethod;
import org.mule.devkit.model.module.connectivity.ConnectionManagementCapability;
import org.mule.devkit.model.studio.AttributeType;
import org.mule.devkit.model.studio.GlobalType;

public class GlobalCloudConnectorConnectionManagementBuilder
extends GlobalCloudConnectorTypeBuilder {
    private ConnectionManagementComponent connectionManagementComponent;

    public GlobalCloudConnectorConnectionManagementBuilder(Context context, Module module, ConnectionManagementComponent connectionManagementComponent, boolean abstrac7, String globalRefId) {
        super(context, module, abstrac7, globalRefId);
        this.connectionManagementComponent = connectionManagementComponent;
    }

    @Override
    protected void buildConnectivityTestingAttr(GlobalType globalCloudConnector) {
        this.setConnectivityTestingAttribute(globalCloudConnector, (Optional<Method>)this.connectionManagementComponent.testConnectivityMethod());
    }

    @Override
    protected String getLocalIdBasedOnType() {
        return this.connectionManagementComponent.configElementName();
    }

    @Override
    protected String getCaptionBasedOnType() {
        return this.helper.getFormattedCaption(this.module).concat(": ").concat(this.connectionManagementComponent.friendlyName());
    }

    @Override
    protected List<Field> getConfigurableFieldsSorted() {
        List configurableFields = this.connectionManagementComponent.getConfigurableFields();
        configurableFields.addAll(this.module.getConfigurableFields());
        Collections.sort(configurableFields, new VariableComparator());
        return configurableFields;
    }

    @Override
    protected String getDescriptionBasedOnType() {
        String javaDocSummary = "Global " + this.connectionManagementComponent.friendlyName() + " configuration information.";
        javaDocSummary = javaDocSummary + (this.connectionManagementComponent.getJavaDocSummary() != null ? " " + this.connectionManagementComponent.getJavaDocSummary() : "");
        return this.helper.formatDescription(javaDocSummary);
    }

    @Override
    protected boolean hasConnectionMethod() {
        return true;
    }

    @Override
    protected ConnectMethod connectMethod() {
        return this.connectionManagementComponent.getConnectMethod();
    }

    @Override
    protected List<AttributeType> getConnectionAttributes() {
        return this.getConnectionAttributes((ConnectionManagementCapability)this.connectionManagementComponent);
    }

    @Override
    protected void setRequiredConnectionParameter(AttributeType attributeType, Variable variable) {
        boolean optional = variable.isOptional() || this.connectionManagementComponent.overridesAtMessageProcessor();
        attributeType.setRequired(Boolean.valueOf(!optional));
    }
}

