/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.generation.studio.editor.callback;

import org.mule.devkit.generation.api.Context;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.studio.AbstractElementType;
import org.mule.devkit.model.studio.NestedElementType;

import javax.xml.bind.JAXBElement;
import java.util.ArrayList;
import java.util.List;

/**
 * Element to render a <nested> element when using {@link org.mule.api.callback.HttpCallback} as parameter in a connector to display the custom properties of an http callback
 */
public class HttpCallbackNestedElementBuilder extends AbstractCallbackNestedElementBuilder {

    public static final String CALLBACK_CONFIG_ELEMENT = "http-callback-config";

    public HttpCallbackNestedElementBuilder(Context context, Module module) {
        super(context, module);
    }

    @Override
    public List<JAXBElement<? extends AbstractElementType>> build() {
        List<JAXBElement<? extends AbstractElementType>> nesteds = new ArrayList<JAXBElement<? extends AbstractElementType>>();
        nesteds.add(objectFactory.createNested(createCallbackConfigNestedElementType(CALLBACK_CONFIG_ELEMENT)));
        return nesteds;
    }

    @Override
    protected void addCustomElements(NestedElementType nestedElementType) {
        //does nothing
    }
}
