/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.generation.studio.utils;

import org.mule.devkit.generation.studio.editor.MuleStudioUtils;
import org.mule.devkit.model.Method;

import java.util.Comparator;

public class MethodsFriendlyNameComparator implements Comparator<Method> {

    MuleStudioUtils muleStudioUtils;

    public MethodsFriendlyNameComparator() {
        muleStudioUtils = new MuleStudioUtils();
    }

    /**
     * Compares two methods from processors, and sorts them using their friendly name.
     *
     * @param method1 a method of a processor
     * @param method2 a method of a processor
     * @return a -1, 0, or 1 as the first method friendly name {@code m} is less than, equal to, or greater than the method friendly name {@code m2}.
     */
    @Override
    public int compare(Method method1, Method method2) {
        String method1Name = muleStudioUtils.getFriendlyName(method1);
        String method2Name = muleStudioUtils.getFriendlyName(method2);
        return method1Name.compareTo(method2Name);
    }
}