/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.generation.studio.editor.globalcloudconnector;


import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.studio.editor.VariableComparator;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.WsdlProviderComponent;
import org.mule.devkit.model.module.connectivity.ConnectMethod;
import org.mule.devkit.model.studio.AttributeType;
import org.mule.devkit.model.studio.GlobalType;

import java.util.Collections;
import java.util.List;

public class GlobalCloudConnectorWsdlProviderBuilder extends GlobalCloudConnectorTypeBuilder {
    private WsdlProviderComponent wsdlProviderComponent;

    public GlobalCloudConnectorWsdlProviderBuilder(Context context, Module module, WsdlProviderComponent wsdlProviderComponent, boolean abstrac7, String globalRefId) {
        super(context, module, abstrac7, globalRefId);
        this.wsdlProviderComponent = wsdlProviderComponent;
    }

    @Override
    protected void buildConnectivityTestingAttr(GlobalType globalCloudConnector) {
        setConnectivityTestingAttribute(globalCloudConnector, wsdlProviderComponent.testConnectivityMethod());
    }

    @Override
    protected List<AttributeType> getConnectionAttributes() {
        return wsdlProviderComponent.hasConnectionManagement() ? getConnectionAttributes(wsdlProviderComponent) : Collections.EMPTY_LIST;
    }

    @Override
    protected List<Field> getConfigurableFieldsSorted() {
        List<Field> configurableFields = module.getConfigurableFields();
        configurableFields.addAll(wsdlProviderComponent.getConfigurableFields());
        Collections.sort(configurableFields, new VariableComparator());
        return configurableFields;
    }

    @Override
    protected boolean isConfigurableVariable(Variable<?> variable) {
        return wsdlProviderComponent.getConfigurableFields().contains(variable);

    }

    @Override
    protected boolean hasConnectionMethod() {
        return wsdlProviderComponent.hasConnectionManagement();
    }

    @Override
    protected ConnectMethod connectMethod() {
        return wsdlProviderComponent.getConnectMethod();
    }

    @Override
    protected String getDescriptionBasedOnType() {
        String javaDocSummary = "Global " + wsdlProviderComponent.friendlyName() + " configuration information.";
        javaDocSummary += wsdlProviderComponent.getJavaDocSummary() != null ? " " + wsdlProviderComponent.getJavaDocSummary() : "";
        return helper.formatDescription(javaDocSummary);
    }

    @Override
    protected String getLocalIdBasedOnType() {
        return wsdlProviderComponent.configElementName();
    }

    @Override
    protected String getCaptionBasedOnType() {
        return helper.getFormattedCaption(module).concat(": ").concat(wsdlProviderComponent.friendlyName());
    }

}
