/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package org.mule.devkit.generation.studio.packaging;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class SignComponent {

    private String keystorePath;
    private final String storepass;
    private final String keypass;
    private final String alias;
    private final String tsaUrl;
    private static final String JARSIGNER_JDK8_CLASS = "sun.security.tools.jarsigner.Main";
    private static final String JARSIGNER_JDK7_CLASS = "sun.security.tools.JarSigner";

    public SignComponent(String keystorePath, String storepass, String keypass, String alias, String tsaUrl) {
        this.keystorePath = keystorePath;
        this.storepass = storepass;
        this.keypass = keypass;
        this.alias = alias;
        this.tsaUrl = tsaUrl;
    }

    private List<String> buildOptions(String path) {
        ArrayList<String> options = new ArrayList<String>();
        options.add("-keystore");
        options.add(keystorePath);

        if (storepass != null) {
            options.add("-storepass");
            options.add(storepass);
        }

        if (keypass != null) {
            options.add("-keypass");
            options.add(keypass);
        }

        if (tsaUrl != null) {
            options.add("-tsa");
            options.add(tsaUrl);
        }

        options.add("-verbose");
        options.add(path);
        options.add(alias);

        return options;
    }

    public void sign(File pluginOrFeature) {
        if (keystorePath != null && new File(keystorePath).exists()) {
            List<String> pluginOrFeatureOptions = buildOptions(pluginOrFeature.getPath());
            if(isUsingJdk8()) {
                jarsignerRun(pluginOrFeatureOptions, JARSIGNER_JDK8_CLASS);
            } else {
                jarsignerRun(pluginOrFeatureOptions, JARSIGNER_JDK7_CLASS);
            }
        }
    }

    private boolean isUsingJdk8() {
        return System.getProperty("java.version").startsWith("1.8");
    }

    // TODO Remove when STUDIO and MULE use java 8 as default.
    @Deprecated
    private void jarsignerRun(List<String> options, String fullyQualifiedClassName) {
        try {
            Class<?> signer = Class.forName(fullyQualifiedClassName);
            Method method = signer.getDeclaredMethod("run", String[].class);
            method.invoke(signer.newInstance(),new Object[]{options.toArray(new String[0])});
        } catch(Exception e) {
            throw new RuntimeException("Could not sign the generated jar file.",e);
        }
    }


}
