/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package org.mule.devkit.generation.studio.packaging;

public enum Placeholder {
    PLUGINS_DIRECTORY {
        @Override
        public <T> T visit(PlaceholderMap<T> placeholderMap) {
            return placeholderMap.visitPlugin(this);
        }

    },
    FEATURES_DIRECTORY {
        @Override
        public <T> T visit(PlaceholderMap<T> placeholderMap) {
            return placeholderMap.visitFeature(this);
        }
    },
    CLASSES_DIRECTORY {
        @Override
        public <T> T visit(PlaceholderMap<T> placeholderMap) {
            return placeholderMap.vistClassesDirectory(this);
        }
    },
    UPDATE_SITE_DIRECTORY {
        @Override
        public <T> T visit(PlaceholderMap<T> placeholderMap) {
            return placeholderMap.visitUpdateSite(this);
        }
    },
    OUTPUT_DIRECTORY {
        @Override
        public <T> T visit(PlaceholderMap<T> placeholderMap) {
            return placeholderMap.visitOutputDirectory(this);
        }
    },
    GENERATED_SOURCES_DIRECTORY {
        @Override
        public <T> T visit(PlaceholderMap<T> placeholderMap) {
            return placeholderMap.visitGeneratedSources(this);
        }
    },
    ROOT_DIRECTORY {
        @Override
        public <T> T visit(PlaceholderMap<T> placeholderMap) {
            return placeholderMap.visitRootDirectory(this);
        }
    };

    public abstract <T> T visit(PlaceholderMap<T> placeholderMap);

    public interface PlaceholderMap<T> {
        T visitPlugin(Placeholder placeholder);

        T visitFeature(Placeholder placeholder);

        T vistClassesDirectory(Placeholder placeholder);

        T visitUpdateSite(Placeholder placeholder);

        T visitOutputDirectory(Placeholder placeholder);

        T visitGeneratedSources(Placeholder placeholder);

        T visitRootDirectory(Placeholder placeholder);

    }

}
