/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */


package org.mule.devkit.generation.studio.editor;

import org.mule.devkit.generation.api.Context;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.schema.SchemaConstants;
import org.mule.devkit.model.studio.AttributeCategory;
import org.mule.devkit.model.studio.AttributeType;
import org.mule.devkit.model.studio.GlobalType;
import org.mule.devkit.model.studio.collection.*;
import org.mule.devkit.utils.NameUtils;

import java.util.List;

public abstract class GlobalTypeBuilder extends BaseStudioXmlBuilder {

    public GlobalTypeBuilder(Context context, Method executableElement, Module module) {
        super(context, executableElement, module);
    }

    public GlobalTypeBuilder(Context context, Module module) {
        super(context, module);
    }

    protected abstract List<AttributeCategory> getAttributeCategories();

    protected abstract String getDescriptionBasedOnType();

    protected abstract String getExtendsBasedOnType();

    protected abstract String getLocalIdBasedOnType();

    protected abstract String getNameDescriptionBasedOnType();

    protected abstract String getImage();

    protected abstract String getIcon();

    protected abstract Boolean isAbstract();

    public GlobalType build() {
        GlobalType globalType = new GlobalType();
        globalType.setImage(getImage());
        globalType.setIcon(getIcon());
        globalType.setCaption(getCaptionBasedOnType());
        globalType.setLocalId(getLocalIdBasedOnType());
        globalType.setExtends(getExtendsBasedOnType());
        globalType.setDescription(getDescriptionBasedOnType());
        globalType.setAbstract(isAbstract());

        globalType.getAttributeCategoryOrRequiredSetAlternativesOrFixedAttribute().addAll(getAttributeCategories());

        return globalType;
    }

    protected AttributeType createNameAttributeType() {
        AttributeType name = new AttributeType();
        name.setName("name");
        name.setCaption(helper.formatCaption("Name"));
        name.setDescription(helper.formatDescription(getNameDescriptionBasedOnType()));
        name.setRequired(true);
        return name;
    }

    protected String getCaptionBasedOnType() {
        return BaseStudioXmlBuilder.GENERAL_GROUP_NAME;
    }

    @Override
    protected AttributeType handleCollectionVariable(Variable parameter) {
        AttributeType attributeType;
        if (helper.isListOfMaps(parameter)) {
            ListOfMapAttributeType objectListAttributeType = new ListOfMapNoExpressionType();
            objectListAttributeType.setRequired(!parameter.isOptional());
            objectListAttributeType.setListName(NameUtils.uncamel(parameter.getName()));
            objectListAttributeType.setInnerName(NameUtils.uncamel(SchemaConstants.INNER_PREFIX + NameUtils.singularize(parameter.getName())));
            objectListAttributeType.setSupportsExpressions(false);
            setCommonCollectionAttributes(parameter, objectListAttributeType);
            attributeType = objectListAttributeType;
        } else if (helper.isSimpleList(parameter) || helper.isSimpleSet(parameter)) {
            StringListAttributeType stringListAttributeType = new StringListNoExpressionType();
            stringListAttributeType.setListName(NameUtils.uncamel(parameter.getName()));
            stringListAttributeType.setSupportsExpressions(false);
            setCommonCollectionAttributes(parameter, stringListAttributeType);
            attributeType = stringListAttributeType;
        } else {
            StringMapAttributeType stringMapAttributeType = new StringMapNoExpressionType();
            stringMapAttributeType.setMapName(NameUtils.uncamel(parameter.getName()));
            stringMapAttributeType.setSupportsExpressions(false);
            setCommonCollectionAttributes(parameter, stringMapAttributeType);
            attributeType = stringMapAttributeType;
        }

        attributeType.setRequired(!parameter.isOptional());
        return attributeType;
    }

    @Override
    protected AttributeType createAttributeTypeFromVariable(Variable<?> variable) {
        AttributeType type = super.createAttributeTypeFromVariable(variable);

        // Until DEVKIT-1211 is supported
        type.setSupportsExpressions(false);
        return type;
    }

    /*
    @Override
    protected AttributeType createComplexListType(Variable parameter) {
        // DEVKIT-1997: Better List of POJOs support

        ObjectListAttributeType objectListAttributeTyper = new ObjectListNoExpressionType();
        objectListAttributeTyper.setListName(NameUtils.uncamel(parameter.getName()));
        objectListAttributeTyper.setSupportsExpressions(false);
        setCommonCollectionAttributes(parameter, objectListAttributeTyper);
        return objectListAttributeTyper;
    }
    */
}