/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */


package org.mule.devkit.generation.studio.editor;

import org.mule.devkit.generation.api.Context;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.studio.GlobalType;

public class GlobalEndpointTypeWithNameBuilder extends GlobalEndpointTypeBuilder {

    public static final String ABSTRACT_GLOBAL_ENDPOINT_LOCAL_ID = "abstractGlobalEndpoint";

    public GlobalEndpointTypeWithNameBuilder(Context context, Module module) {
        super(context, null, module);
    }

    @Override
    public GlobalType build() {
        GlobalType globalEndpoint = super.build();
        globalEndpoint.setAbstract(true);
        return globalEndpoint;
    }

    protected String getDescriptionBasedOnType() {
        return "";
    }

    protected String getExtendsBasedOnType() {
        return null;
    }

    protected String getLocalIdBasedOnType() {
        return ABSTRACT_GLOBAL_ENDPOINT_LOCAL_ID;
    }

    protected String getCaptionBasedOnType() {
        return "";
    }

    protected String getNameDescriptionBasedOnType() {
        return "Endpoint name";
    }

    @Override
    protected String getDoNotInherit() {
        return null;
    }
}