/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */


package org.mule.devkit.generation.studio;

import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.MultiModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.studio.packaging.ArchiverPlan;
import org.mule.devkit.generation.utils.SerializationUtils;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.util.IOUtils;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SerializableArchiverPlanGenerator extends AbstractMuleStudioGenerator implements MultiModuleGenerator {

    public final static String PACKAGE_DESCRIPTOR_PATH = "package.descriptor";

    private final static List<Product> CONSUMES = Arrays.asList(Product.STUDIO_FEATURE);

    @Override
    public List<Product> consumes() {
        return CONSUMES;
    }

    @Override
    public boolean shouldGenerate(List<Module> modules) {
        for (Module module : modules) {
            if (module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC) {
                return true;
            }
        }

        return false;
    }

    @Override
    public List<Module> processableModules(List<Module> modules) {
        List<Module> processableModules = new ArrayList<Module>();
        for (Module module : modules) {
            if (module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC) {
                processableModules.add(module);
            }
        }
        return processableModules;
    }

    @Override
    public void generate(List<Module> modules) throws GenerationException {
        ObjectOutputStream objectOutputStream = null;

        try {
            OutputStream outputStream = ctx().getCodeModel().getCodeWriter().openBinary(null, PACKAGE_DESCRIPTOR_PATH);
            SerializationUtils.save(outputStream, ctx().<ArchiverPlan>getProduct(Product.STUDIO_FEATURE));
        } catch (IOException e) {
            throw new GenerationException(String.format("Could not create package descriptor file: [%s] for Studio plugin: ",
                    PACKAGE_DESCRIPTOR_PATH) + e.getMessage(), e);
        } finally {
            IOUtils.closeQuietly(objectOutputStream);
        }
    }
}
