/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.studio.editor.GlobalTypeBuilder;
import org.mule.devkit.generation.studio.editor.MethodComparator;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.TransformerMethod;
import org.mule.devkit.model.studio.AttributeCategory;
import org.mule.devkit.model.studio.GlobalType;

public class GlobalTransformerTypeOperationsBuilder
extends GlobalTypeBuilder {
    public GlobalTransformerTypeOperationsBuilder(Context context, Module module) {
        super(context, module);
    }

    @Override
    protected List<AttributeCategory> getAttributeCategories() {
        AttributeCategory attributeCategory = new AttributeCategory();
        attributeCategory.setCaption(this.helper.formatCaption("General"));
        attributeCategory.setDescription(this.helper.formatDescription("General"));
        attributeCategory.getGroup().add(this.createGroupWithModeSwitch(this.getTransformerMethodsSorted()));
        ArrayList<AttributeCategory> attributeCategories = new ArrayList<AttributeCategory>();
        attributeCategories.add(attributeCategory);
        return attributeCategories;
    }

    private List<TransformerMethod> getTransformerMethodsSorted() {
        List transformer = this.module.getTransformerMethods();
        Collections.sort(transformer, new MethodComparator());
        return transformer;
    }

    @Override
    protected String getDescriptionBasedOnType() {
        return this.helper.formatDescription("Global transformer");
    }

    @Override
    protected String getExtendsBasedOnType() {
        return "http://www.mulesoft.org/schema/mule/" + this.module.getModuleName() + '/' + "abstractTransformer";
    }

    @Override
    protected String getLocalIdBasedOnType() {
        return "global-transformer";
    }

    @Override
    protected String getCaptionBasedOnType() {
        return this.helper.getFormattedCaption(this.module);
    }

    @Override
    protected String getNameDescriptionBasedOnType() {
        return "Identifies the transformer so that other elements can reference it.";
    }

    @Override
    protected String getImage() {
        return this.helper.getTransformerImage(this.module);
    }

    @Override
    protected String getIcon() {
        return this.helper.getTransformerIcon(this.module);
    }

    @Override
    protected Boolean isAbstract() {
        return false;
    }

    @Override
    public GlobalType build() {
        GlobalType globalTransformer = super.build();
        globalTransformer.setVersions(this.buildVersionsString());
        return globalTransformer;
    }
}

