/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.MultiModuleGenerator;
import org.mule.devkit.generation.studio.AbstractMuleStudioGenerator;
import org.mule.devkit.generation.studio.utils.ModuleComparator;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;

public abstract class AbstractMuleStudioNamespaceGenerator
extends AbstractMuleStudioGenerator
implements MultiModuleGenerator {
    public boolean shouldGenerate(List<Module> modules) {
        for (Module module : modules) {
            if (module.getKind() != ModuleKind.CONNECTOR && module.getKind() != ModuleKind.GENERIC) continue;
            return true;
        }
        return false;
    }

    public List<Module> processableModules(List<Module> modules) {
        ArrayList<Module> specificModules = new ArrayList<Module>();
        for (Module module : modules) {
            if (module.getKind() != ModuleKind.CONNECTOR && module.getKind() != ModuleKind.GENERIC) continue;
            specificModules.add(module);
        }
        return specificModules;
    }

    public void generate(List<Module> modules) throws GenerationException {
        for (Module module : this.createListOfNamespaces(modules)) {
            this.generate(module);
        }
    }

    private Collection<Module> createListOfNamespaces(List<Module> modules) {
        HashMap<String, Module> namespaces = new HashMap<String, Module>();
        ArrayList<Module> sortedModules = new ArrayList<Module>(modules);
        Collections.sort(sortedModules, new ModuleComparator());
        for (Module module : sortedModules) {
            if (module.getKind() != ModuleKind.CONNECTOR && module.getKind() != ModuleKind.GENERIC || namespaces.containsKey(module.getModuleName())) continue;
            namespaces.put(module.getModuleName(), module);
        }
        return namespaces.values();
    }

    public abstract void generate(Module var1) throws GenerationException;
}

