/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio.editor.globalcloudconnector;

import com.google.common.base.Optional;
import java.util.Collections;
import java.util.List;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.studio.editor.VariableComparator;
import org.mule.devkit.generation.studio.editor.globalcloudconnector.GlobalCloudConnectorTypeBuilder;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.WsdlProviderComponent;
import org.mule.devkit.model.module.connectivity.ConnectMethod;
import org.mule.devkit.model.studio.AttributeType;
import org.mule.devkit.model.studio.GlobalType;

public class GlobalCloudConnectorWsdlProviderBuilder
extends GlobalCloudConnectorTypeBuilder {
    private WsdlProviderComponent wsdlProviderComponent;

    public GlobalCloudConnectorWsdlProviderBuilder(Context context, Module module, WsdlProviderComponent wsdlProviderComponent, boolean abstrac7, String globalRefId) {
        super(context, module, abstrac7, globalRefId);
        this.wsdlProviderComponent = wsdlProviderComponent;
    }

    @Override
    protected void buildConnectivityTestingAttr(GlobalType globalCloudConnector) {
        this.setConnectivityTestingAttribute(globalCloudConnector, (Optional<Method>)this.wsdlProviderComponent.testConnectivityMethod());
    }

    @Override
    protected List<AttributeType> getConnectionAttributes() {
        return Collections.EMPTY_LIST;
    }

    @Override
    protected List<Field> getConfigurableFieldsSorted() {
        List configurableFields = this.module.getConfigurableFields();
        configurableFields.addAll(this.wsdlProviderComponent.getConfigurableFields());
        Collections.sort(configurableFields, new VariableComparator());
        return configurableFields;
    }

    @Override
    protected boolean hasConnectionMethod() {
        return false;
    }

    @Override
    protected ConnectMethod connectMethod() {
        return null;
    }

    @Override
    protected String getDescriptionBasedOnType() {
        String javaDocSummary = "Global " + this.wsdlProviderComponent.friendlyName() + " configuration information.";
        javaDocSummary = javaDocSummary + (this.wsdlProviderComponent.getJavaDocSummary() != null ? " " + this.wsdlProviderComponent.getJavaDocSummary() : "");
        return this.helper.formatDescription(javaDocSummary);
    }

    @Override
    protected String getLocalIdBasedOnType() {
        return this.wsdlProviderComponent.configElementName();
    }

    @Override
    protected String getCaptionBasedOnType() {
        return this.helper.getFormattedCaption(this.module).concat(": ").concat(this.wsdlProviderComponent.friendlyName());
    }
}

