package org.mule.devkit.generation.studio.utils;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import java.io.FileReader;
import java.io.IOException;

/**
 * Util class for handling xml unmarshall with JAXB
 */
public abstract class JaxbUnmarshaller {

    public static class UnmarshallException extends RuntimeException{

        public UnmarshallException(String msg){
            super(msg);
        }

        public UnmarshallException(Exception e){
            super(e);
        }

        public UnmarshallException(String msg, Exception e){
            super(msg, e);
        }
    }

    /**
     *  Unmarshall xml to specified type using JAXB. This method never returns null.
     *  @param inputFile source xml file with object description
     *  @param type declared object type to unmarshall
     *  @throws JAXBException
     * */
    public static <T> T unmarshallXml(String inputFile, Class type) throws UnmarshallException {

        try {
            JAXBContext jc = JAXBContext.newInstance(type);
            Unmarshaller unmarshaller = jc.createUnmarshaller();

            return (T)unmarshaller.unmarshal(new FileReader(inputFile));

        } catch (IOException e) {
            throw new UnmarshallException("Missing verifier, an error occurred while trying to read the file " + inputFile +
                                          " while unmarshalling", e);
        } catch (JAXBException e) {
            throw new UnmarshallException("Missing verifier, an error occurred while processing the file " + inputFile +
                                          " while unmarshalling", e);
        }
    }
}
