package org.mule.devkit.generation.studio.editor.globalcloudconnector;

import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.studio.editor.VariableComparator;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.HttpBasicAuthComponent;
import org.mule.devkit.model.module.connectivity.ConnectMethod;
import org.mule.devkit.model.studio.AttributeType;
import org.mule.devkit.model.studio.GlobalType;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GlobalCloudConnectorHttpBasicAuthBuilder extends GlobalCloudConnectorTypeBuilder {
    private HttpBasicAuthComponent httpBasicAuthComponent;

    public GlobalCloudConnectorHttpBasicAuthBuilder(Context context, Module module, HttpBasicAuthComponent httpBasicAuthComponent, boolean abstrac7, String globalRefId) {
        super(context, module, abstrac7, globalRefId);
        this.httpBasicAuthComponent = httpBasicAuthComponent;
    }

    @Override
    protected void buildConnectivityTestingAttr(GlobalType globalCloudConnector) {
        setConnectivityTestingAttribute(globalCloudConnector, httpBasicAuthComponent.testConnectivityMethod());
    }

    @Override
    protected List<Field> getConfigurableFieldsSorted() {
        List<Field> configurableFields = module.getConfigurableFields();
        Collections.sort(configurableFields, new VariableComparator());
        return configurableFields;
    }

    @Override
    protected boolean hasConnectionMethod() {
        return false;
    }

    @Override
    protected ConnectMethod connectMethod() {
        return null;
    }

    @Override
    protected String getDescriptionBasedOnType() {
        String javaDocSummary = "Global " + httpBasicAuthComponent.friendlyName() + " configuration information.";
        javaDocSummary += httpBasicAuthComponent.getJavaDocSummary() != null ? " " + httpBasicAuthComponent.getJavaDocSummary() : "";
        return helper.formatDescription(javaDocSummary);    }

    @Override
    protected String getLocalIdBasedOnType() {
        return httpBasicAuthComponent.configElementName();
    }

    @Override
    protected String getCaptionBasedOnType() {
        return helper.getFormattedCaption(module).concat(": ").concat(httpBasicAuthComponent.friendlyName());
    }

    @Override
    protected List<AttributeType> getConnectionAttributes() {
        List<Field> configurableFields = new ArrayList<Field>();
        configurableFields.add(httpBasicAuthComponent.username());
        if (httpBasicAuthComponent.password().isPresent()){
            configurableFields.add(httpBasicAuthComponent.password().get());
        }
        return getConnectionAttributes(configurableFields);
    }
}
