package org.mule.devkit.generation.studio.editor.globalcloudconnector;

import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.studio.editor.VariableComparator;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.ConnectionManagementComponent;
import org.mule.devkit.model.module.connectivity.ConnectMethod;
import org.mule.devkit.model.studio.AttributeType;
import org.mule.devkit.model.studio.GlobalType;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GlobalCloudConnectorConnectionManagementBuilder extends GlobalCloudConnectorTypeBuilder {

    private ConnectionManagementComponent connectionManagementComponent;

    public GlobalCloudConnectorConnectionManagementBuilder(Context context, Module module, ConnectionManagementComponent connectionManagementComponent, boolean abstrac7, String globalRefId) {
        super(context, module, abstrac7, globalRefId);
        this.connectionManagementComponent = connectionManagementComponent;
    }

    @Override
    protected void buildConnectivityTestingAttr(GlobalType globalCloudConnector) {
        setConnectivityTestingAttribute(globalCloudConnector, connectionManagementComponent.testConnectivityMethod());
    }

    @Override
    protected String getLocalIdBasedOnType() {
        return connectionManagementComponent.configElementName();
    }

    @Override
    protected String getCaptionBasedOnType() {
        return helper.getFormattedCaption(module).concat(": ").concat(connectionManagementComponent.friendlyName());
    }

    @Override
    protected List<Field> getConfigurableFieldsSorted() {
        List<Field> configurableFields = connectionManagementComponent.getConfigurableFields();
        configurableFields.addAll(module.getConfigurableFields());
        Collections.sort(configurableFields, new VariableComparator());
        return configurableFields;
    }

    @Override
    protected String getDescriptionBasedOnType() {
        String javaDocSummary = "Global " + connectionManagementComponent.friendlyName() + " configuration information.";
        javaDocSummary += connectionManagementComponent.getJavaDocSummary() != null ? " " + connectionManagementComponent.getJavaDocSummary() : "";
        return helper.formatDescription(javaDocSummary);
    }

    @Override
    protected boolean hasConnectionMethod() {
        return true;
    }

    @Override
    protected ConnectMethod connectMethod(){
        return connectionManagementComponent.getConnectMethod();
    }

    @Override
    protected List<AttributeType> getConnectionAttributes() {
        return getConnectionAttributes(connectionManagementComponent);
    }

    /**
     * Useful to mark in Studio that the current parameter should be written in the global element
     * @param attributeType
     * @param variable
     */
    @Override
    protected void setRequiredConnectionParameter(AttributeType attributeType, Variable variable) {
        boolean optional = variable.isOptional() || connectionManagementComponent.overridesAtMessageProcessor();
        attributeType.setRequired(!optional);
    }
}
