/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */


package org.mule.devkit.generation.studio.editor.callback;

import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.studio.editor.BaseStudioXmlBuilder;
import org.mule.devkit.generation.utils.OAuth2StrategyUtilsResolver;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.oauth.OAuthCapability;
import org.mule.devkit.model.module.oauth.OAuthVersion;
import org.mule.devkit.model.schema.SchemaConstants;
import org.mule.devkit.model.studio.*;

import javax.xml.bind.JAXBElement;
import java.util.ArrayList;
import java.util.List;

/**
 * Element to render a <nested> element when using {@link org.mule.api.annotations.oauth.OAuth2} in a connector, to display the custom properties of an http callback
 */
public class OAuthConfigNestedElementsBuilder extends AbstractCallbackNestedElementBuilder {

    public static final String OAUTH_CALLBACK_CONFIG_ELEMENT = "oauth-callback-config";
    public static final String OAUTH_STORE_CONFIG_ELEMENT = "oauth-store-config";

    public OAuthConfigNestedElementsBuilder(Context context, Module module) {
        super(context, module);
    }

    public List<JAXBElement<? extends AbstractElementType>> build() {
        List<JAXBElement<? extends AbstractElementType>> nesteds = new ArrayList<JAXBElement<? extends AbstractElementType>>(2);
        nesteds.add(objectFactory.createNested(createCallbackConfigNestedElementType(OAUTH_CALLBACK_CONFIG_ELEMENT)));
        nesteds.add(objectFactory.createNested(createStoreConfigNestedElementType()));
        return nesteds;
    }

    /**
     * Adding custom accessTokenId attribute only if the connector supports OAuth2
     * @param nestedElementType the list of elements that had been previously filled with "domain, local port, remote port, path and http connector-ref" attributes
     */
    @Override
    protected void addCustomElements(NestedElementType nestedElementType) {
        OAuthCapability oAuthCapability = OAuth2StrategyUtilsResolver.getOAuthCapability(this.module);
        if (oAuthCapability.getOAuthVersion() == OAuthVersion.V2) {
            StringAttributeType defaultAccessTokenId = helper.createStringAttributeType("Default Access Token Id", "A Mule Expression to use as access token id", SchemaConstants.DEFAULT_ACCESS_TOKEN_ID_ATTRIBUTE_NAME);
            nestedElementType.getRegexpOrEncodingOrString().add(helper.createJAXBElement(defaultAccessTokenId));
        }
    }

    private NestedElementType createStoreConfigNestedElementType() {
        NestedElementType nestedElementType = new NestedElementType();
        nestedElementType.setLocalId(OAUTH_STORE_CONFIG_ELEMENT);
        nestedElementType.setAbstract(true);
        nestedElementType.setCaption("");
        nestedElementType.setDescription(SchemaConstants.OAUTH_STORE_CONFIG_ELEMENT_DESCRIPTION);

        StringAttributeType objectStoreRefAttribute = helper.createStringAttributeType("Object store reference", "Object store reference", SchemaConstants.OBJECT_STORE_REF_ATTRIBUTE_NAME);
        nestedElementType.getRegexpOrEncodingOrString().add(helper.createJAXBElement(objectStoreRefAttribute));

        return nestedElementType;
    }
}